/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl;

import java.io.InputStream;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;

public final class InitializeSchedulingAssistantDatabase {
    public static final String CONFIG = System.getProperty(InitializeSchedulingAssistantDatabase.class.getPackage().getName() + ".InitializeAvailableDatabase.CONFIG", "database.xml");
    private static Log LOG = LogFactory.getLog(InitializeSchedulingAssistantDatabase.class);
    private JdbcTemplate jdbcTemplate;

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public static void main(String[] args) throws Exception {
        Resource destroyDdl;
        LOG.info((Object)("loading applicationContext: " + CONFIG));
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(CONFIG);
        boolean firstRun = false;
        if (args.length == 1) {
            firstRun = Boolean.parseBoolean(args[0]);
        }
        InitializeSchedulingAssistantDatabase init = new InitializeSchedulingAssistantDatabase();
        init.setDataSource((DataSource)context.getBean("dataSource"));
        if (!firstRun && null != (destroyDdl = (Resource)context.getBean("destroyDdl"))) {
            String destroySql = IOUtils.toString((InputStream)destroyDdl.getInputStream());
            init.executeDdl(destroySql);
            LOG.warn((Object)"existing tables removed");
        }
        Resource createDdl = (Resource)context.getBean("createDdl");
        String createSql = IOUtils.toString((InputStream)createDdl.getInputStream());
        init.executeDdl(createSql);
        LOG.info((Object)"database initialization complete");
    }

    @Transactional
    protected void executeDdl(String sql) {
        LOG.debug((Object)("attempting to execute: " + sql));
        this.jdbcTemplate.execute(sql);
    }
}

