/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.caching;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class EhCacheExpiredEvictor
implements Runnable {
    private Log LOG = LogFactory.getLog(this.getClass());
    private CacheManager cacheManager;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    @Scheduled(fixedDelay=1800000L)
    public void run() {
        long startTime = System.currentTimeMillis();
        String[] cacheNames = this.cacheManager.getCacheNames();
        long evictedElements = 0L;
        for (String cacheName : cacheNames) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            long preEvictSize = cache.getMemoryStoreSize();
            long evictStart = System.currentTimeMillis();
            cache.evictExpiredElements();
            if (!this.LOG.isDebugEnabled()) continue;
            long evicted = preEvictSize - cache.getMemoryStoreSize();
            evictedElements += evicted;
            this.LOG.debug((Object)("Evicted " + evicted + " elements from cache '" + cacheName + "' in " + (System.currentTimeMillis() - evictStart) + " ms"));
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Evicted " + evictedElements + " elements from " + cacheNames.length + " caches  in " + (System.currentTimeMillis() - startTime) + " ms"));
        }
    }
}

