/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.events;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.events.AutomaticAppointmentCancellationEvent;
import org.jasig.schedassist.impl.events.EmailNotificationApplicationListener;
import org.jasig.schedassist.model.ICalendarAccount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class AutomaticAppointmentCancellationApplicationListener
implements ApplicationListener<AutomaticAppointmentCancellationEvent> {
    private Log LOG = LogFactory.getLog(this.getClass());
    private MailSender mailSender;
    private String noReplyFromAddress = "no.reply.wisccal@doit.wisc.edu";

    @Autowired
    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setNoReplyFromAddress(String noReplyFromAddress) {
        this.noReplyFromAddress = noReplyFromAddress;
    }

    @Async
    public void onApplicationEvent(AutomaticAppointmentCancellationEvent event) {
        ICalendarAccount owner = event.getOwner();
        VEvent vevent = event.getEvent();
        PropertyList attendeeList = vevent.getProperties("ATTENDEE");
        SimpleMailMessage message = new SimpleMailMessage();
        ArrayList<String> recipients = new ArrayList<String>();
        for (Object o : attendeeList) {
            Property attendee = (Property)o;
            String value = attendee.getValue();
            String email = value.substring("mailto:".length());
            if (EmailNotificationApplicationListener.isEmailAddressValid(email)) {
                recipients.add(email);
                continue;
            }
            this.LOG.debug((Object)("skipping invalid email: " + email));
        }
        message.setTo(recipients.toArray(new String[0]));
        if (!EmailNotificationApplicationListener.isEmailAddressValid(owner.getEmailAddress())) {
            message.setFrom(this.noReplyFromAddress);
        } else {
            message.setFrom(owner.getEmailAddress());
        }
        message.setSubject(vevent.getSummary().getValue() + " has been cancelled");
        message.setText(this.constructMessageBody(vevent, event.getReason(), owner.getDisplayName()));
        this.LOG.debug((Object)("sending message: " + message.toString()));
        this.mailSender.send(message);
        this.LOG.debug((Object)"message successfully sent");
    }

    protected String constructMessageBody(VEvent event, AutomaticAppointmentCancellationEvent.Reason reason, String ownerName) {
        StringBuilder body = new StringBuilder();
        body.append("WiscCal Scheduling Assistant has automatically cancelled the following appointment: ");
        body.append(EmailNotificationApplicationListener.NEWLINE);
        body.append(EmailNotificationApplicationListener.NEWLINE);
        body.append("Title: ");
        body.append(event.getSummary().getValue());
        body.append(EmailNotificationApplicationListener.NEWLINE);
        SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy");
        SimpleDateFormat tf = new SimpleDateFormat("h:mm a");
        body.append(df.format((Date)event.getStartDate().getDate()));
        body.append(EmailNotificationApplicationListener.NEWLINE);
        body.append("Time: ");
        body.append(tf.format((Date)event.getStartDate().getDate()));
        body.append(" to ");
        body.append(tf.format((Date)event.getEndDate(true).getDate()));
        body.append(EmailNotificationApplicationListener.NEWLINE);
        body.append("Location: ");
        body.append(event.getLocation().getValue());
        body.append(EmailNotificationApplicationListener.NEWLINE);
        body.append(EmailNotificationApplicationListener.NEWLINE);
        body.append("This appointment was automatically cancelled because ");
        if (AutomaticAppointmentCancellationEvent.Reason.OWNER_DECLINED.equals((Object)reason)) {
            body.append("the Schedule Owner (");
            body.append(ownerName);
            body.append(") specified via WiscCal that they will not be able to attend.");
        } else if (AutomaticAppointmentCancellationEvent.Reason.NO_REMAINING_VISITORS.equals((Object)reason)) {
            body.append("the visiting attendee(s) specified via WiscCal that they will not be able to attend.");
        }
        return body.toString();
    }
}

