/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.events;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Summary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.events.AutomaticAttendeeRemovalEvent;
import org.jasig.schedassist.impl.events.EmailNotificationApplicationListener;
import org.jasig.schedassist.model.ICalendarAccount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.MessageSource;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class AutomaticAttendeeRemovalApplicationListener
implements ApplicationListener<AutomaticAttendeeRemovalEvent> {
    private Log LOG = LogFactory.getLog(this.getClass());
    private MailSender mailSender;
    private MessageSource messageSource;
    private String noReplyFromAddress = "no.reply.wisccal@doit.wisc.edu";

    @Autowired
    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setNoReplyFromAddress(String noReplyFromAddress) {
        this.noReplyFromAddress = noReplyFromAddress;
    }

    @Async
    public void onApplicationEvent(AutomaticAttendeeRemovalEvent event) {
        ICalendarAccount owner = event.getOwner();
        VEvent vevent = event.getEvent();
        Property removedAttendee = event.getRemoved();
        SimpleMailMessage message = new SimpleMailMessage();
        if (!EmailNotificationApplicationListener.isEmailAddressValid(owner.getEmailAddress())) {
            message.setFrom(this.noReplyFromAddress);
        } else {
            message.setFrom(owner.getEmailAddress());
        }
        String removedAttendeeEmail = removedAttendee.getValue().substring("mailto:".length());
        message.setTo(removedAttendeeEmail);
        Summary summary = vevent.getSummary();
        if (summary != null) {
            message.setSubject(summary.getValue() + " has been updated");
        } else {
            this.LOG.warn((Object)("event is missing summary: " + (Object)((Object)event)));
            message.setSubject("Appointment has been updated");
        }
        message.setText(this.constructMessageBody(vevent, removedAttendee, owner.getDisplayName()));
        this.LOG.debug((Object)("sending message: " + message.toString()));
        this.mailSender.send(message);
        this.LOG.debug((Object)"message successfully sent");
    }

    protected String constructMessageBody(VEvent event, Property removedAttendee, String ownerName) {
        StringBuilder body = new StringBuilder();
        Parameter cn = removedAttendee.getParameter("CN");
        body.append(this.messageSource.getMessage("automatic.attendee.remove.notify.introduction", (Object[])new String[]{cn.getValue()}, null));
        body.append(EmailNotificationApplicationListener.NEWLINE);
        body.append(EmailNotificationApplicationListener.NEWLINE);
        Summary summary = event.getSummary();
        if (summary != null) {
            body.append(this.messageSource.getMessage("notify.email.title", (Object[])new String[]{summary.getValue()}, null));
            body.append(EmailNotificationApplicationListener.NEWLINE);
        }
        SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy");
        SimpleDateFormat tf = new SimpleDateFormat("h:mm a");
        body.append(df.format((Date)event.getStartDate().getDate()));
        body.append(EmailNotificationApplicationListener.NEWLINE);
        body.append(this.messageSource.getMessage("notify.email.time", (Object[])new String[]{tf.format((Date)event.getStartDate().getDate()), tf.format((Date)event.getEndDate(true).getDate())}, null));
        Location location = event.getLocation();
        if (location != null) {
            body.append(EmailNotificationApplicationListener.NEWLINE);
            body.append(this.messageSource.getMessage("notify.email.location", (Object[])new String[]{location.getValue()}, null));
        }
        body.append(EmailNotificationApplicationListener.NEWLINE);
        body.append(EmailNotificationApplicationListener.NEWLINE);
        body.append(this.messageSource.getMessage("automatic.attendee.remove.notify.footer", null, null));
        return body.toString();
    }
}

