/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.events;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.events.AbstractAppointmentEvent;
import org.jasig.schedassist.impl.events.AppointmentCancelledEvent;
import org.jasig.schedassist.impl.events.AppointmentCreatedEvent;
import org.jasig.schedassist.impl.events.AppointmentJoinedEvent;
import org.jasig.schedassist.impl.events.AppointmentLeftEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class LoggingApplicationListener
implements ApplicationListener<AbstractAppointmentEvent> {
    private Log LOG = LogFactory.getLog(this.getClass());

    @Async
    public void onApplicationEvent(AbstractAppointmentEvent event) {
        if (event instanceof AppointmentCreatedEvent) {
            AppointmentCreatedEvent a = (AppointmentCreatedEvent)event;
            this.LOG.info((Object)("create appointment: " + a.getOwner() + ", " + a.getVisitor() + ", " + a.getBlock()));
        } else if (event instanceof AppointmentCancelledEvent) {
            AppointmentCancelledEvent a = (AppointmentCancelledEvent)event;
            this.LOG.info((Object)("cancel appointment: " + a.getOwner() + ", " + a.getVisitor() + ", " + a.getBlock()));
        } else if (event instanceof AppointmentJoinedEvent) {
            AppointmentJoinedEvent a = (AppointmentJoinedEvent)event;
            this.LOG.info((Object)("join appointment: " + a.getOwner() + ", " + a.getVisitor() + ", " + a.getBlock()));
        } else if (event instanceof AppointmentLeftEvent) {
            AppointmentLeftEvent a = (AppointmentLeftEvent)event;
            this.LOG.info((Object)("left appointment: " + a.getOwner() + ", " + a.getVisitor() + ", " + a.getBlock()));
        }
    }
}

