/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.reminder;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Summary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.SchedulingAssistantService;
import org.jasig.schedassist.impl.events.EmailNotificationApplicationListener;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.reminder.IReminder;
import org.jasig.schedassist.impl.reminder.PersistedReminderImpl;
import org.jasig.schedassist.impl.reminder.ReminderDao;
import org.jasig.schedassist.impl.reminder.ReminderImpl;
import org.jasig.schedassist.impl.reminder.ReminderService;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.Reminders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.mail.MailSendException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class DefaultReminderServiceImpl
implements ReminderService,
Runnable {
    private static final String NEWLINE = System.getProperty("line.separator");
    private ReminderDao reminderDao;
    private MailSender mailSender;
    private OwnerDao ownerDao;
    private SchedulingAssistantService schedulingAssistantService;
    private ICalendarAccountDao calendarAccountDao;
    private MessageSource messageSource;
    private String noReplyFromAddress = "no.reply.wisccal@doit.wisc.edu";
    private final Log LOG = LogFactory.getLog(this.getClass());

    @Autowired
    public void setReminderDao(ReminderDao reminderDao) {
        this.reminderDao = reminderDao;
    }

    @Autowired
    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setSchedulingAssistantService(SchedulingAssistantService schedulingAssistantService) {
        this.schedulingAssistantService = schedulingAssistantService;
    }

    @Autowired
    public void setCalendarAccountDao(@Qualifier(value="composite") ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setNoReplyFromAddress(String noReplyFromAddress) {
        this.noReplyFromAddress = noReplyFromAddress;
    }

    @Override
    public IReminder createEventReminder(IScheduleOwner owner, ICalendarAccount recipient, AvailableBlock appointmentBlock, VEvent event, Date sendTime) {
        return this.reminderDao.createEventReminder(owner, recipient, appointmentBlock, event, sendTime);
    }

    @Override
    public void deleteEventReminder(IReminder reminder) {
        this.reminderDao.deleteEventReminder(reminder);
    }

    @Override
    public List<IReminder> getPendingReminders() {
        List<PersistedReminderImpl> persisted = this.reminderDao.getPendingReminders();
        ArrayList<IReminder> results = new ArrayList<IReminder>(persisted.size());
        for (PersistedReminderImpl p : persisted) {
            ReminderImpl reminder = this.complete(p);
            if (reminder == null) continue;
            results.add(reminder);
        }
        return results;
    }

    @Override
    public IReminder getReminder(IScheduleOwner owner, ICalendarAccount recipient, AvailableBlock appointmentBlock) {
        PersistedReminderImpl persisted = this.reminderDao.getReminder(owner, recipient, appointmentBlock);
        ReminderImpl result = this.complete(persisted);
        return result;
    }

    protected ReminderImpl complete(PersistedReminderImpl p) {
        if (p == null) {
            return null;
        }
        IScheduleOwner scheduleOwner = this.ownerDao.locateOwnerByAvailableId(p.getOwnerId());
        ICalendarAccount recipient = this.calendarAccountDao.getCalendarAccount(p.getRecipientId());
        VEvent event = this.schedulingAssistantService.getExistingAppointment(p.getTargetBlock(), scheduleOwner);
        ReminderImpl reminder = new ReminderImpl(p.getReminderId(), scheduleOwner, recipient, p.getSendTime(), event);
        return reminder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPendingReminders() {
        String propertyValue = System.getProperty("org.jasig.schedassist.runScheduledTasks", "true");
        if (Boolean.parseBoolean(propertyValue)) {
            List<IReminder> pending = this.getPendingReminders();
            int size = pending.size();
            if (size == 0) {
                return;
            }
            this.LOG.info((Object)("begin processing " + size + " pending reminders"));
            for (IReminder reminder : pending) {
                try {
                    this.sendEmail(reminder);
                }
                finally {
                    this.deleteEventReminder(reminder);
                }
            }
            this.LOG.info((Object)("completed processing " + size + " reminders"));
        } else {
            this.LOG.debug((Object)"ignoring processPendingReminders as 'org.jasig.schedassist.runScheduledTasks' set to false");
        }
    }

    protected void sendEmail(IReminder reminder) {
        IScheduleOwner owner = reminder.getScheduleOwner();
        ICalendarAccount recipient = reminder.getRecipient();
        VEvent event = reminder.getEvent();
        if (null != owner && null != recipient && null != event) {
            Reminders reminderPrefs = owner.getRemindersPreference();
            boolean includeOwner = reminderPrefs.isIncludeOwner();
            SimpleMailMessage message = new SimpleMailMessage();
            if (!EmailNotificationApplicationListener.isEmailAddressValid(owner.getCalendarAccount().getEmailAddress())) {
                message.setFrom(this.noReplyFromAddress);
            } else {
                message.setFrom(owner.getCalendarAccount().getEmailAddress());
            }
            if (includeOwner) {
                message.setTo(new String[]{owner.getCalendarAccount().getEmailAddress(), recipient.getEmailAddress()});
            } else {
                message.setTo(new String[]{recipient.getEmailAddress()});
            }
            message.setSubject("Reminder: " + event.getSummary().getValue());
            String messageBody = this.createMessageBody(event, owner);
            message.setText(messageBody);
            this.LOG.debug((Object)("sending message: " + message.toString()));
            try {
                this.mailSender.send(message);
                this.LOG.debug((Object)"message successfully sent");
            }
            catch (MailSendException e) {
                this.LOG.error((Object)("caught MailSendException for " + owner + ", " + recipient + ", " + reminder), (Throwable)e);
            }
        } else {
            this.LOG.debug((Object)("skipping send email for reminder with null elements: " + reminder));
        }
    }

    protected String createMessageBody(VEvent event, IScheduleOwner owner) {
        StringBuilder messageBody = new StringBuilder();
        messageBody.append(this.messageSource.getMessage("reminder.email.introduction", (Object[])new String[]{owner.getCalendarAccount().getDisplayName()}, null));
        messageBody.append(NEWLINE);
        messageBody.append(NEWLINE);
        Summary summary = event.getSummary();
        if (summary != null) {
            messageBody.append(this.messageSource.getMessage("reminder.email.title", (Object[])new String[]{summary.getValue()}, null));
            messageBody.append(NEWLINE);
        }
        SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy");
        SimpleDateFormat tf = new SimpleDateFormat("h:mm a");
        messageBody.append(df.format((Date)event.getStartDate().getDate()));
        messageBody.append(NEWLINE);
        messageBody.append(this.messageSource.getMessage("reminder.email.time", (Object[])new String[]{tf.format((Date)event.getStartDate().getDate()), tf.format((Date)event.getEndDate(true).getDate())}, null));
        Location location = event.getLocation();
        if (location != null) {
            messageBody.append(NEWLINE);
            messageBody.append(this.messageSource.getMessage("reminder.email.location", (Object[])new String[]{location.getValue()}, null));
        }
        messageBody.append(NEWLINE);
        messageBody.append(NEWLINE);
        messageBody.append(this.messageSource.getMessage("reminder.email.footer", null, null));
        return messageBody.toString();
    }

    @Override
    @Scheduled(fixedDelay=60000L)
    public void run() {
        this.processPendingReminders();
    }
}

