/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.reminder;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.reminder.IReminder;
import org.jasig.schedassist.impl.reminder.PersistedReminderImpl;
import org.jasig.schedassist.impl.reminder.PersistedReminderImplRowMapper;
import org.jasig.schedassist.impl.reminder.ReminderDao;
import org.jasig.schedassist.impl.reminder.ReminderImpl;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
class SpringJdbcReminderDaoImpl
implements ReminderDao {
    private SimpleJdbcTemplate simpleJdbcTemplate;
    private DataFieldMaxValueIncrementer reminderIdSequence;
    private Log LOG = LogFactory.getLog(this.getClass());

    SpringJdbcReminderDaoImpl() {
    }

    @Autowired
    public void setDataSource(DataSource ds) {
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(ds);
    }

    @Autowired
    public void setReminderIdSequence(@Qualifier(value="reminders") DataFieldMaxValueIncrementer reminderIdSequence) {
        this.reminderIdSequence = reminderIdSequence;
    }

    @Override
    @Transactional
    public IReminder createEventReminder(IScheduleOwner owner, ICalendarAccount recipient, AvailableBlock appointmentBlock, VEvent event, Date sendTime) {
        long newReminderId = this.reminderIdSequence.nextLongValue();
        int rows = this.simpleJdbcTemplate.update("insert into reminders (reminder_id,owner_id,recipient,event_start,event_end,send_time) values (?,?,?,?,?,?)", new Object[]{newReminderId, owner.getId(), recipient.getUsername(), appointmentBlock.getStartTime(), appointmentBlock.getEndTime(), sendTime});
        if (rows == 1) {
            ReminderImpl reminder = new ReminderImpl(newReminderId, owner, recipient, sendTime, event);
            return reminder;
        }
        this.LOG.error((Object)("failed to store reminder for " + owner + ", " + recipient));
        return null;
    }

    @Override
    @Transactional
    public void deleteEventReminder(IReminder reminder) {
        int rows = this.simpleJdbcTemplate.update("delete from reminders where reminder_id=?", new Object[]{reminder.getReminderId()});
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("delete " + reminder + ", rows affected=" + rows));
        }
    }

    @Override
    public List<PersistedReminderImpl> getPendingReminders() {
        Date now = new Date();
        List persisted = this.simpleJdbcTemplate.query("select * from reminders where send_time <= ?", (RowMapper)new PersistedReminderImplRowMapper(), new Object[]{now});
        return persisted;
    }

    @Override
    public PersistedReminderImpl getReminder(IScheduleOwner owner, ICalendarAccount recipient, AvailableBlock appointmentBlock) {
        List persisted = this.simpleJdbcTemplate.query("select * from reminders where owner_id=? and recipient=? and event_start=? and event_end=?", (RowMapper)new PersistedReminderImplRowMapper(), new Object[]{owner.getId(), recipient.getUsername(), appointmentBlock.getStartTime(), appointmentBlock.getEndTime()});
        PersistedReminderImpl p = (PersistedReminderImpl)DataAccessUtils.singleResult((Collection)persisted);
        return p;
    }
}

