/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.services.persondir.IPersonAttributeDao;

public abstract class AbstractDefaultAttributePersonAttributeDao
implements IPersonAttributeDao {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String defaultAttribute = "username";

    public final Map getUserAttributes(String uid) {
        if (uid == null) {
            throw new IllegalArgumentException("Illegal to invoke getUserAttributes(String) with null argument.");
        }
        Map<String, String> seed = Collections.singletonMap(this.getDefaultAttributeName(), uid);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created seed map='" + seed + "' for uid='" + uid + "'"));
        }
        Map userAttributes = this.getUserAttributes(seed);
        return userAttributes;
    }

    public final String getDefaultAttributeName() {
        return this.defaultAttribute;
    }

    public final void setDefaultAttributeName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The default attribute name may not be null");
        }
        this.defaultAttribute = name;
    }
}

