/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.support.AbstractDefaultAttributePersonAttributeDao;

public class CachingPersonAttributeDaoImpl
extends AbstractDefaultAttributePersonAttributeDao {
    protected static final Map NULL_RESULTS_OBJECT = Collections.singletonMap(CachingPersonAttributeDaoImpl.class.getName() + "UNIQUE_NULL_RESULTS_MAP", new Integer(CachingPersonAttributeDaoImpl.class.hashCode()));
    protected Log statsLogger = LogFactory.getLog((String)(this.getClass().getName() + ".statistics"));
    private long queries = 0L;
    private long misses = 0L;
    private IPersonAttributeDao cachedPersonAttributesDao = null;
    private Map userInfoCache = null;
    private Set cacheKeyAttributes = null;
    private boolean cacheNullResults = false;
    private Map nullResultsObject = NULL_RESULTS_OBJECT;

    public IPersonAttributeDao getCachedPersonAttributesDao() {
        return this.cachedPersonAttributesDao;
    }

    public void setCachedPersonAttributesDao(IPersonAttributeDao cachedPersonAttributesDao) {
        if (cachedPersonAttributesDao == null) {
            throw new IllegalArgumentException("cachedPersonAttributesDao may not be null");
        }
        this.cachedPersonAttributesDao = cachedPersonAttributesDao;
    }

    public Set getCacheKeyAttributes() {
        return this.cacheKeyAttributes;
    }

    public void setCacheKeyAttributes(Set cacheKeyAttributes) {
        this.cacheKeyAttributes = cacheKeyAttributes;
    }

    public Map getUserInfoCache() {
        return this.userInfoCache;
    }

    public void setUserInfoCache(Map userInfoCache) {
        if (userInfoCache == null) {
            throw new IllegalArgumentException("userInfoCache may not be null");
        }
        this.userInfoCache = userInfoCache;
    }

    public boolean isCacheNullResults() {
        return this.cacheNullResults;
    }

    public void setCacheNullResults(boolean cacheNullResults) {
        this.cacheNullResults = cacheNullResults;
    }

    public Map getNullResultsObject() {
        return this.nullResultsObject;
    }

    public void setNullResultsObject(Map nullResultsObject) {
        if (nullResultsObject == null) {
            throw new IllegalArgumentException("nullResultsObject may not be null");
        }
        this.nullResultsObject = nullResultsObject;
    }

    public long getMisses() {
        return this.misses;
    }

    public long getQueries() {
        return this.queries;
    }

    public Map getUserAttributes(Map seed) {
        if (seed == null) {
            throw new IllegalArgumentException("The query seed Map cannot be null.");
        }
        if (this.cachedPersonAttributesDao == null) {
            throw new IllegalStateException("No 'cachedPersonAttributesDao' has been specified.");
        }
        if (this.userInfoCache == null) {
            throw new IllegalStateException("No 'userInfoCache' has been specified.");
        }
        Serializable cacheKey = this.getCacheKey(seed);
        if (cacheKey != null) {
            Map cacheResults = (Map)this.userInfoCache.get(cacheKey);
            if (cacheResults != null) {
                if (((Object)this.nullResultsObject).equals(cacheResults)) {
                    cacheResults = null;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Retrieved query from cache. key='" + cacheKey + "', results='" + cacheResults + "'"));
                }
                ++this.queries;
                if (this.statsLogger.isDebugEnabled()) {
                    this.statsLogger.debug((Object)("Cache Stats: queries=" + this.queries + ", hits=" + (this.queries - this.misses) + ", misses=" + this.misses));
                }
                return cacheResults;
            }
            Map queryResults = this.cachedPersonAttributesDao.getUserAttributes(seed);
            if (queryResults != null) {
                this.userInfoCache.put(cacheKey, queryResults);
            } else if (this.cacheNullResults) {
                this.userInfoCache.put(cacheKey, this.nullResultsObject);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieved query from wrapped IPersonAttributeDao and stored in cache. key='" + cacheKey + "', results='" + queryResults + "'"));
            }
            ++this.queries;
            ++this.misses;
            if (this.statsLogger.isDebugEnabled()) {
                this.statsLogger.debug((Object)("Cache Stats: queries=" + this.queries + ", hits=" + (this.queries - this.misses) + ", misses=" + this.misses));
            }
            return queryResults;
        }
        this.logger.warn((Object)("No cache key generated, caching disabled for this query. query='" + seed + "', cacheKeyAttributes=" + this.cacheKeyAttributes + "', defaultAttributeName='" + this.getDefaultAttributeName() + "'"));
        ++this.queries;
        ++this.misses;
        if (this.statsLogger.isDebugEnabled()) {
            this.statsLogger.debug((Object)("Cache Stats: queries=" + this.queries + ", hits=" + (this.queries - this.misses) + ", misses=" + this.misses));
        }
        return this.cachedPersonAttributesDao.getUserAttributes(seed);
    }

    public Set getPossibleUserAttributeNames() {
        return this.cachedPersonAttributesDao.getPossibleUserAttributeNames();
    }

    protected Serializable getCacheKey(Map querySeed) {
        HashMap cacheKey = new HashMap();
        if (this.cacheKeyAttributes == null || this.cacheKeyAttributes.size() == 0) {
            String defaultAttrName = this.getDefaultAttributeName();
            if (querySeed.containsKey(defaultAttrName)) {
                cacheKey.put(defaultAttrName, querySeed.get(defaultAttrName));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created cacheKey='" + cacheKey + "' from query='" + querySeed + "' using default attribute='" + defaultAttrName + "'"));
            }
        } else {
            Iterator attrItr = this.cacheKeyAttributes.iterator();
            while (attrItr.hasNext()) {
                String attr = (String)attrItr.next();
                if (!querySeed.containsKey(attr)) continue;
                cacheKey.put(attr, querySeed.get(attr));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created cacheKey='" + cacheKey + "' from query='" + querySeed + "' using attributes='" + this.cacheKeyAttributes + "'"));
            }
        }
        if (cacheKey.size() > 0) {
            return cacheKey;
        }
        return null;
    }
}

