/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.support.AbstractDefaultAttributePersonAttributeDao;

public final class RegexGatewayPersonAttributeDao
extends AbstractDefaultAttributePersonAttributeDao {
    private boolean matchAllPatterns = false;
    private boolean matchAllValues = false;
    private Map patterns = null;
    private IPersonAttributeDao targetPersonAttributeDao = null;

    public RegexGatewayPersonAttributeDao(String attributeName, String pattern, IPersonAttributeDao enclosed) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Argument 'attributeName' cannot be null.");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 'pattern' cannot be null.");
        }
        this.setDefaultAttributeName(attributeName);
        this.setPatterns(Collections.singletonMap(this.getDefaultAttributeName(), pattern));
        this.setTargetPersonAttributeDao(enclosed);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created RegexGatewayPersonAttributeDao with defaultAttributeName='" + this.getDefaultAttributeName() + "' and patterns=" + this.patterns));
        }
    }

    public Map getPatterns() {
        return this.patterns;
    }

    public void setPatterns(Map patterns) {
        if (patterns == null || patterns.size() < 1) {
            throw new IllegalArgumentException("patterns Map may not be null and must contain at least 1 mapping.");
        }
        this.patterns = Collections.unmodifiableMap(new HashMap(patterns));
    }

    public IPersonAttributeDao getTargetPersonAttributeDao() {
        return this.targetPersonAttributeDao;
    }

    public void setTargetPersonAttributeDao(IPersonAttributeDao targetPersonAttributeDao) {
        if (targetPersonAttributeDao == null) {
            throw new IllegalArgumentException("targetPersonAttributeDao may not be null");
        }
        this.targetPersonAttributeDao = targetPersonAttributeDao;
    }

    public boolean isMatchAllPatterns() {
        return this.matchAllPatterns;
    }

    public void setMatchAllPatterns(boolean matchAllPatterns) {
        this.matchAllPatterns = matchAllPatterns;
    }

    public boolean isMatchAllValues() {
        return this.matchAllValues;
    }

    public void setMatchAllValues(boolean matchAllValues) {
        this.matchAllValues = matchAllValues;
    }

    public Map getUserAttributes(Map seed) {
        if (seed == null) {
            throw new IllegalArgumentException("Argument 'seed' cannot be null.");
        }
        if (this.patterns == null || this.patterns.size() < 1) {
            throw new IllegalStateException("patterns Map may not be null and must contain at least 1 mapping.");
        }
        if (this.targetPersonAttributeDao == null) {
            throw new IllegalStateException("targetPersonAttributeDao may not be null");
        }
        boolean matchedPatterns = false;
        Iterator patternEntryItr = this.patterns.entrySet().iterator();
        while (patternEntryItr.hasNext()) {
            Map.Entry patternEntry = patternEntryItr.next();
            String attributeName = (String)patternEntry.getKey();
            Object attributeValue = seed.get(attributeName);
            if (attributeValue == null) {
                if (!this.matchAllPatterns) continue;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("All patterns must match and attribute='" + attributeName + "' does not exist in the seed, returning null."));
                }
                return null;
            }
            List valueList = attributeValue instanceof List ? (List)attributeValue : Collections.singletonList(attributeValue);
            String pattern = (String)patternEntry.getValue();
            if (pattern == null) {
                throw new IllegalStateException("Attribute '" + attributeName + "' has a null pattern");
            }
            Pattern compiledPattern = Pattern.compile(pattern);
            boolean matchedValues = false;
            Iterator valueItr = valueList.iterator();
            while (valueItr.hasNext()) {
                String value;
                try {
                    value = (String)valueItr.next();
                }
                catch (ClassCastException cce) {
                    IllegalArgumentException iae = new IllegalArgumentException("RegexGatewayPersonAttributeDao can only accept seeds who's values are String or List of String. Attribute '" + attributeName + "' has a non-String value.");
                    iae.initCause(cce);
                    throw iae;
                }
                Matcher valueMatcher = compiledPattern.matcher(value);
                matchedValues = valueMatcher.matches();
                if (matchedValues && !this.matchAllValues) {
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug((Object)("value='" + value + "' matched pattern='" + pattern + "' and only one value match is needed, leaving value matching loop."));
                    break;
                }
                if (!matchedValues && this.matchAllValues) {
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug((Object)("value='" + value + "' did not match pattern='" + pattern + "' and all values need to match, leaving value matching loop."));
                    break;
                }
                if (!this.logger.isDebugEnabled()) continue;
                if (matchedValues) {
                    this.logger.debug((Object)("value='" + value + "' matched pattern='" + pattern + "' and all values need to match, continuing value matching loop."));
                    continue;
                }
                this.logger.debug((Object)("value='" + value + "' did not match pattern='" + pattern + "' and only one value match is needed, continuing value matching loop."));
            }
            if ((matchedPatterns = matchedValues) && !this.matchAllPatterns) {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug((Object)("pattern='" + pattern + "' found a match and only one pattern match is needed, leaving pattern matching loop."));
                break;
            }
            if (!matchedPatterns && this.matchAllPatterns) {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug((Object)("pattern='" + pattern + "' did not find a match and all patterns need to match, leaving pattern matching loop."));
                break;
            }
            if (!this.logger.isDebugEnabled()) continue;
            if (matchedPatterns) {
                this.logger.debug((Object)("pattern='" + pattern + "' found a match and all patterns need to match, continuing pattern matching loop."));
                continue;
            }
            this.logger.debug((Object)("pattern='" + pattern + "' did not find a match and only one pattern match is needed, continuing pattern matching loop."));
        }
        if (matchedPatterns) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Matching criteria was met, delegating call to the targetPersonAttributeDao='" + this.targetPersonAttributeDao + "'"));
            }
            return this.targetPersonAttributeDao.getUserAttributes(seed);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Matching criteria was not met, return null");
        }
        return null;
    }

    public Set getPossibleUserAttributeNames() {
        return this.targetPersonAttributeDao.getPossibleUserAttributeNames();
    }
}

