/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.jasig.services.persondir.support.jdbc.AbstractPersonAttributeMappingQuery;
import org.jasig.services.persondir.support.jdbc.MultiRowJdbcPersonAttributeDao;

class MultiRowPersonAttributeMappingQuery
extends AbstractPersonAttributeMappingQuery {
    private final MultiRowJdbcPersonAttributeDao parentMultiRowPersonAttributeDao;

    public MultiRowPersonAttributeMappingQuery(DataSource ds, String sql, List queryAttributes, MultiRowJdbcPersonAttributeDao parentMultiRowPersonAttributeDao) {
        super(ds, sql, queryAttributes);
        if (parentMultiRowPersonAttributeDao == null) {
            throw new IllegalArgumentException("parentMultiRowPersonAttributeDao may not be null");
        }
        this.parentMultiRowPersonAttributeDao = parentMultiRowPersonAttributeDao;
    }

    protected Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        HashMap rowResults = new HashMap();
        Map nameValueColumnMappings = this.parentMultiRowPersonAttributeDao.getNameValueColumnMappings();
        if (nameValueColumnMappings == null) {
            throw new IllegalStateException("Property nameValueColumnMappings on MultiRowJdbcPersonAttributeDao='" + this.parentMultiRowPersonAttributeDao + "' can not be null");
        }
        Set colNames = nameValueColumnMappings.keySet();
        Iterator columnNameItr = colNames.iterator();
        while (columnNameItr.hasNext()) {
            String columnName = (String)columnNameItr.next();
            this.addMappedAttributes(rs, columnName, rowResults);
        }
        return rowResults;
    }

    private void addMappedAttributes(ResultSet rs, String nameColumn, Map rowResults) throws SQLException {
        String attributeName;
        if (nameColumn == null || nameColumn.length() <= 0) {
            throw new IllegalArgumentException("columnName cannot be null and must have length >= 0");
        }
        try {
            attributeName = rs.getString(nameColumn);
        }
        catch (SQLException sqle) {
            this.logger.error((Object)("Was unable to read attribute for column [" + nameColumn + "]"));
            throw sqle;
        }
        Map nameValueColumnMappings = this.parentMultiRowPersonAttributeDao.getNameValueColumnMappings();
        Set valueCols = (Set)nameValueColumnMappings.get(nameColumn);
        Iterator valueColItr = valueCols.iterator();
        while (valueColItr.hasNext()) {
            String valueColumn = (String)valueColItr.next();
            try {
                String attributeValue = rs.getString(valueColumn);
                MultivaluedPersonAttributeUtils.addResult(rowResults, attributeName, attributeValue);
            }
            catch (SQLException sqle) {
                this.logger.error((Object)("Was unable to read attribute for column [" + valueColumn + "]"));
                throw sqle;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Retrieved " + valueCols.size() + " values for name column '" + nameColumn + "'"));
        }
    }
}

