/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.ldap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.springframework.ldap.AttributesMapper;

class PersonAttributesMapper
implements AttributesMapper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map ldapAttributesToPortalAttributes;

    public PersonAttributesMapper(Map ldapAttributesToPortalAttributes) {
        if (ldapAttributesToPortalAttributes == null) {
            throw new IllegalArgumentException("ldapAttributesToPortalAttributes may not be null");
        }
        this.ldapAttributesToPortalAttributes = ldapAttributesToPortalAttributes;
    }

    public Map getLdapAttributesToPortalAttributes() {
        return this.ldapAttributesToPortalAttributes;
    }

    public Object mapFromAttributes(Attributes attributes) throws NamingException {
        HashMap rowResults = new HashMap();
        Iterator ldapAttrIter = this.ldapAttributesToPortalAttributes.keySet().iterator();
        while (ldapAttrIter.hasNext()) {
            String ldapAttributeName = (String)ldapAttrIter.next();
            Attribute attribute = attributes.get(ldapAttributeName);
            if (attribute == null) continue;
            Set<String> attributeNames = (Set<String>)this.ldapAttributesToPortalAttributes.get(ldapAttributeName);
            if (attributeNames == null) {
                attributeNames = Collections.singleton(ldapAttributeName);
            }
            int valueCount = 0;
            NamingEnumeration<?> attrValueEnum = attribute.getAll();
            while (attrValueEnum.hasMore()) {
                Object attributeValue = attrValueEnum.next();
                if (!(attributeValue instanceof byte[])) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)("Converting value " + valueCount + " of LDAP attribute '" + ldapAttributeName + "' from byte[] to String"));
                    }
                    attributeValue = attributeValue.toString();
                }
                Iterator<String> attrNameItr = attributeNames.iterator();
                while (attrNameItr.hasNext()) {
                    String attributeName = attrNameItr.next();
                    MultivaluedPersonAttributeUtils.addResult(rowResults, attributeName, attributeValue);
                }
                ++valueCount;
            }
            if (!this.logger.isDebugEnabled()) continue;
            if (this.ldapAttributesToPortalAttributes.containsKey(ldapAttributeName)) {
                this.logger.debug((Object)("Added " + valueCount + " attributes under mapped names '" + attributeNames + "' for source attribute '" + ldapAttributeName + "'"));
                continue;
            }
            this.logger.debug((Object)("Added " + valueCount + " attributes for source attribute '" + ldapAttributeName + "'"));
        }
        return rowResults;
    }
}

