/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.rule;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jasig.services.persondir.support.rule.AttributeRule;

public final class SimpleAttributeRule
implements AttributeRule {
    private final String whenKey;
    private final String whenPattern;
    private final String setKey;
    private final String setValue;
    private final Set possibleAttributeNames;

    public SimpleAttributeRule(String whenKey, String whenPattern, String setKey, String setValue) {
        if (whenKey == null) {
            String msg = "Argument 'whenKey' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (whenPattern == null) {
            String msg = "Argument 'whenPattern' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (setKey == null) {
            String msg = "Argument 'setKey' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (setValue == null) {
            String msg = "Argument 'setValue' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        this.whenKey = whenKey;
        this.whenPattern = whenPattern;
        this.setKey = setKey;
        this.setValue = setValue;
        this.possibleAttributeNames = Collections.singleton(this.setKey);
    }

    public boolean appliesTo(Map userInfo) {
        if (userInfo == null) {
            String msg = "Argument 'userInfo' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        Object value = userInfo.get(this.whenKey);
        if (value == null) {
            return false;
        }
        String[] compare = null;
        if (value instanceof String) {
            compare = new String[]{(String)value};
        } else if (value instanceof String[]) {
            compare = (String[])value;
        } else if (value instanceof List) {
            List list = (List)value;
            try {
                compare = list.toArray(new String[list.size()]);
            }
            catch (ClassCastException cce) {
                String msg = "List values may contain only String instances.";
                throw new RuntimeException(msg, cce);
            }
        } else {
            String msg = "The value of " + this.whenKey + " must be a String, String[], or List<String> " + "instance.  Found:  " + value.getClass().getName();
            throw new RuntimeException(msg);
        }
        boolean rslt = false;
        for (int i = 0; i < compare.length; ++i) {
            if (!compare[i].matches(this.whenPattern)) continue;
            rslt = true;
            break;
        }
        return rslt;
    }

    public Map evaluate(Map userInfo) {
        if (userInfo == null) {
            String msg = "Argument 'userInfo' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (!this.appliesTo(userInfo)) {
            String msg = "May not evaluate.  This rule does not apply.";
            throw new IllegalArgumentException(msg);
        }
        HashMap<String, String> rslt = new HashMap<String, String>();
        rslt.put(this.setKey, this.setValue);
        return rslt;
    }

    public Set getPossibleUserAttributeNames() {
        return this.possibleAttributeNames;
    }
}

