/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.AbstractAggregatingDefaultQueryPersonAttributeDao;
import org.jasig.services.persondir.support.merger.ReplacingAttributeAdder;

public class CascadingPersonAttributeDao
extends AbstractAggregatingDefaultQueryPersonAttributeDao {
    private boolean stopIfFirstDaoReturnsNull = false;

    public void setStopIfFirstDaoReturnsNull(boolean stopIfFirstDaoReturnsNull) {
        this.stopIfFirstDaoReturnsNull = stopIfFirstDaoReturnsNull;
    }

    public CascadingPersonAttributeDao() {
        this.attrMerger = new ReplacingAttributeAdder();
    }

    @Override
    protected Set<IPersonAttributes> getAttributesFromDao(Map<String, List<Object>> seed, boolean isFirstQuery, IPersonAttributeDao currentlyConsidering, Set<IPersonAttributes> resultPeople) {
        if (isFirstQuery || !this.stopIfFirstDaoReturnsNull && (resultPeople == null || resultPeople.size() == 0)) {
            return currentlyConsidering.getPeopleWithMultivaluedAttributes(seed);
        }
        if (this.stopIfFirstDaoReturnsNull && !isFirstQuery && (resultPeople == null || resultPeople.size() == 0)) {
            return null;
        }
        Set<IPersonAttributes> mergedPeopleResults = null;
        for (IPersonAttributes person : resultPeople) {
            LinkedHashMap<String, List<Object>> queryAttributes = new LinkedHashMap<String, List<Object>>();
            String userName = person.getName();
            if (userName != null) {
                Map<String, List<Object>> userNameMap = this.toSeedMap(userName);
                queryAttributes.putAll(userNameMap);
            }
            Map personAttributes = person.getAttributes();
            queryAttributes.putAll(personAttributes);
            Set newResults = currentlyConsidering.getPeopleWithMultivaluedAttributes(queryAttributes);
            if (newResults == null) continue;
            if (mergedPeopleResults == null) {
                mergedPeopleResults = new LinkedHashSet<IPersonAttributes>(newResults);
                continue;
            }
            mergedPeopleResults = this.attrMerger.mergeResults(mergedPeopleResults, newResults);
        }
        return mergedPeopleResults;
    }
}

