/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.springframework.mock.web.portlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.filter.FilterConfig;
import org.springframework.mock.web.portlet.MockPortletContext;
import org.springframework.util.Assert;

public class MockFilterConfig
implements FilterConfig {
    private final PortletContext portletContext;
    private final String filterName;
    private final Map<String, String> initParameters = new LinkedHashMap<String, String>();

    public MockFilterConfig() {
        this(null, "");
    }

    public MockFilterConfig(String filterName) {
        this(null, filterName);
    }

    public MockFilterConfig(PortletContext portletContext) {
        this(portletContext, "");
    }

    public MockFilterConfig(PortletContext portletContext, String filterName) {
        this.portletContext = portletContext != null ? portletContext : new MockPortletContext();
        this.filterName = filterName;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        this.initParameters.put(name, value);
    }

    public String getInitParameter(String name) {
        return this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }
}

