/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.internal.PriorityServiceComparator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public final class OSGIServiceHelper {
    private static final Logger LOG = Logger.getLogger(OSGIServiceHelper.class.getName());

    private OSGIServiceHelper() {
    }

    public Enumeration<URL> getResources(BundleContext bundleContext, String resource) {
        LOG.finest("TAMAYA  Loading resources: " + resource);
        ArrayList<URL> result = new ArrayList<URL>();
        URL url = bundleContext.getBundle().getEntry(resource);
        if (url != null) {
            LOG.finest("TAMAYA  Resource: " + resource + " found in unregistered bundle " + bundleContext.getBundle().getSymbolicName());
            result.add(url);
        }
        for (Bundle bundle : bundleContext.getBundles()) {
            url = bundle.getEntry(resource);
            if (url == null || result.contains(url)) continue;
            LOG.finest("TAMAYA  Resource: " + resource + " found in registered bundle " + bundle.getSymbolicName());
            result.add(url);
        }
        for (Bundle bundle : bundleContext.getBundles()) {
            url = bundle.getEntry(resource);
            if (url == null || result.contains(url)) continue;
            LOG.finest("TAMAYA  Resource: " + resource + " found in unregistered bundle " + bundle.getSymbolicName());
            result.add(url);
        }
        return Collections.enumeration(result);
    }

    public static <T> void registerService(Bundle bundle, Class<T> serviceClass, Class<? extends T> implClass) {
        try {
            LOG.info("Loaded Service Factory (" + serviceClass.getName() + "): " + implClass.getName());
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("version", bundle.getVersion().toString());
            String vendor = (String)bundle.getHeaders().get("Bundle-Vendor");
            props.put("service.vendor", vendor != null ? vendor : "anonymous");
            props.put("service.ranking", String.valueOf(PriorityServiceComparator.getPriority(implClass)));
            JDKUtilServiceFactory factory = new JDKUtilServiceFactory(implClass);
            BundleContext bundleContext = bundle.getBundleContext();
            bundleContext.registerService(serviceClass.getName(), (Object)factory, props);
            LOG.info("Registered Tamaya service class: " + implClass.getName() + "(" + serviceClass.getName() + ")");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to load service: " + implClass.getName(), e);
        }
    }

    public static <T> void unregisterService(Bundle bundle, Class<T> serviceClass, Class<? extends T> implClass) {
        try {
            LOG.fine("Unloading Service (" + serviceClass.getName() + "): " + implClass.getName());
            ServiceReference ref = bundle.getBundleContext().getServiceReference(implClass);
            if (ref != null) {
                bundle.getBundleContext().ungetService(ref);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to unload service: " + implClass.getName(), e);
        }
    }

    static class JDKUtilServiceFactory
    implements ServiceFactory {
        private final Class<?> serviceClass;

        public JDKUtilServiceFactory(Class<?> serviceClass) {
            this.serviceClass = serviceClass;
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            try {
                LOG.fine("Creating Service...:" + this.serviceClass.getName());
                return this.serviceClass.newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Failed to create service: " + this.serviceClass.getName(), ex);
            }
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

