/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Optional;
import javax.money.AbstractContext;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryContextBuilder;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.MonetaryQuery;
import javax.money.NumberValue;
import javax.money.RoundingQuery;
import javax.money.RoundingQueryBuilder;
import javax.money.format.MonetaryAmountFormat;
import org.javamoney.moneta.FastMoney;
import org.javamoney.moneta.Money;
import org.javamoney.moneta.NumberVerifier;
import org.javamoney.moneta.RoundedMoneyMonetaryOperatorFactory;
import org.javamoney.moneta.ToStringMonetaryAmountFormat;
import org.javamoney.moneta.internal.RoundedMoneyAmountFactory;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.MoneyUtils;

public final class RoundedMoney
implements MonetaryAmount,
Comparable<MonetaryAmount>,
Serializable {
    private static final long serialVersionUID = -6716367273185192901L;
    public static final MonetaryContext DEFAULT_MONETARY_CONTEXT = ((MonetaryContextBuilder)MonetaryContextBuilder.of(RoundedMoney.class).set("MonetaryRounding", (Object)Monetary.getDefaultRounding())).build();
    private final CurrencyUnit currency;
    private final MonetaryContext monetaryContext;
    private final BigDecimal number;
    private final MonetaryOperator rounding;
    private static final ToStringMonetaryAmountFormat DEFAULT_FORMATTER = ToStringMonetaryAmountFormat.of(ToStringMonetaryAmountFormat.ToStringMonetaryAmountFormatStyle.ROUNDED_MONEY);

    public RoundedMoney(Number number, CurrencyUnit currency, MonetaryOperator rounding) {
        this(number, currency, null, rounding);
    }

    @Deprecated
    public RoundedMoney(Number number, CurrencyUnit currency, MathContext mathContext) {
        Objects.requireNonNull(currency, "Currency is required.");
        this.currency = currency;
        this.rounding = Monetary.getRounding((RoundingQuery)((RoundingQueryBuilder)RoundingQueryBuilder.of().set((Object)mathContext)).build());
        this.monetaryContext = ((MonetaryContextBuilder)((MonetaryContextBuilder)DEFAULT_MONETARY_CONTEXT.toBuilder().set("MonetaryRounding", (Object)this.rounding)).set((Object)mathContext)).build();
        Objects.requireNonNull(number, "Number is required.");
        this.checkNumber(number);
        this.number = MoneyUtils.getBigDecimal(number, this.monetaryContext);
    }

    @Deprecated
    public RoundedMoney(Number number, CurrencyUnit currency, MonetaryContext context, MonetaryOperator rounding) {
        Objects.requireNonNull(currency, "Currency is required.");
        this.currency = currency;
        Objects.requireNonNull(number, "Number is required.");
        this.checkNumber(number);
        MonetaryContextBuilder monetaryContextBuilder = DEFAULT_MONETARY_CONTEXT.toBuilder();
        this.rounding = RoundedMoneyMonetaryOperatorFactory.INSTANCE.getDefaultMonetaryOperator(rounding, context, monetaryContextBuilder);
        monetaryContextBuilder.set("MonetaryRounding", (Object)this.rounding);
        if (context != null) {
            monetaryContextBuilder.importContext((AbstractContext)context);
        }
        this.monetaryContext = monetaryContextBuilder.build();
        this.number = MoneyUtils.getBigDecimal(number, this.monetaryContext);
    }

    public static RoundedMoney of(BigDecimal number, CurrencyUnit currency) {
        return new RoundedMoney((Number)number, currency, (MonetaryOperator)Monetary.getDefaultRounding());
    }

    public static RoundedMoney of(BigDecimal number, CurrencyUnit currency, MonetaryOperator rounding) {
        return new RoundedMoney((Number)number, currency, rounding);
    }

    public static RoundedMoney of(BigDecimal number, CurrencyUnit currency, MathContext mathContext) {
        return new RoundedMoney((Number)number, currency, mathContext);
    }

    @Deprecated
    public static RoundedMoney of(Number number, CurrencyUnit currency) {
        return new RoundedMoney(number, currency, (MonetaryOperator)null);
    }

    public static RoundedMoney of(Number number, CurrencyUnit currency, MonetaryOperator rounding) {
        return new RoundedMoney(number, currency, rounding);
    }

    public static RoundedMoney of(Number number, CurrencyUnit currency, MonetaryContext monetaryContext) {
        return new RoundedMoney(number, currency, ((MonetaryContextBuilder)DEFAULT_MONETARY_CONTEXT.toBuilder().importContext((AbstractContext)monetaryContext)).build(), null);
    }

    @Deprecated
    public static RoundedMoney of(CurrencyUnit currency, Number number, MonetaryContext monetaryContext, MonetaryOperator rounding) {
        return new RoundedMoney(number, currency, ((MonetaryContextBuilder)DEFAULT_MONETARY_CONTEXT.toBuilder().importContext((AbstractContext)monetaryContext)).build(), rounding);
    }

    @Deprecated
    public static RoundedMoney of(Number number, String currencyCode) {
        return new RoundedMoney(number, Monetary.getCurrency((String)currencyCode, (String[])new String[0]), (MonetaryOperator)Monetary.getDefaultRounding());
    }

    public static RoundedMoney of(Number number, String currencyCode, MonetaryOperator rounding) {
        return new RoundedMoney(number, Monetary.getCurrency((String)currencyCode, (String[])new String[0]), rounding);
    }

    @Deprecated
    public static RoundedMoney of(Number number, String currencyCode, MonetaryContext monetaryContext) {
        return new RoundedMoney(number, Monetary.getCurrency((String)currencyCode, (String[])new String[0]), ((MonetaryContextBuilder)DEFAULT_MONETARY_CONTEXT.toBuilder().importContext((AbstractContext)monetaryContext)).build(), null);
    }

    public static RoundedMoney of(String currencyCode, Number number, MonetaryContext monetaryContext, MonetaryOperator rounding) {
        return new RoundedMoney(number, Monetary.getCurrency((String)currencyCode, (String[])new String[0]), ((MonetaryContextBuilder)DEFAULT_MONETARY_CONTEXT.toBuilder().importContext((AbstractContext)monetaryContext)).build(), rounding);
    }

    public static RoundedMoney zero(CurrencyUnit currency) {
        return RoundedMoney.of(BigDecimal.ZERO, currency);
    }

    public static RoundedMoney ofMinor(CurrencyUnit currency, long amountMinor) {
        return RoundedMoney.ofMinor(currency, amountMinor, currency.getDefaultFractionDigits());
    }

    public static RoundedMoney ofMinor(CurrencyUnit currency, long amountMinor, int factionDigits) {
        if (factionDigits < 0) {
            throw new IllegalArgumentException("The factionDigits cannot be negative");
        }
        return RoundedMoney.of(BigDecimal.valueOf(amountMinor, factionDigits), currency);
    }

    public CurrencyUnit getCurrency() {
        return this.currency;
    }

    public MonetaryContext getContext() {
        return this.monetaryContext;
    }

    public RoundedMoney abs() {
        if (this.isPositiveOrZero()) {
            return this;
        }
        return this.negate();
    }

    public RoundedMoney add(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        if (amount.isZero()) {
            return this;
        }
        return new RoundedMoney((Number)this.number.add((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)), this.currency, this.rounding).with(this.rounding);
    }

    public RoundedMoney divide(Number divisor) {
        BigDecimal bd = MoneyUtils.getBigDecimal(divisor);
        if (this.isOne(bd)) {
            return this;
        }
        BigDecimal dec = this.number.divide(bd, Optional.ofNullable((RoundingMode)((Object)this.monetaryContext.get(RoundingMode.class))).orElse(RoundingMode.HALF_EVEN));
        return new RoundedMoney((Number)dec, this.currency, this.rounding).with(this.rounding);
    }

    public RoundedMoney[] divideAndRemainder(Number divisor) {
        BigDecimal bd = MoneyUtils.getBigDecimal(divisor);
        if (this.isOne(bd)) {
            return new RoundedMoney[]{this, new RoundedMoney((Number)0L, this.getCurrency(), this.rounding)};
        }
        BigDecimal[] dec = this.number.divideAndRemainder(MoneyUtils.getBigDecimal(divisor), Optional.ofNullable((MathContext)this.monetaryContext.get(MathContext.class)).orElse(MathContext.DECIMAL64));
        return new RoundedMoney[]{new RoundedMoney((Number)dec[0], this.currency, this.rounding), new RoundedMoney((Number)dec[1], this.currency, this.rounding).with(this.rounding)};
    }

    public RoundedMoney divideToIntegralValue(Number divisor) {
        BigDecimal dec = this.number.divideToIntegralValue(MoneyUtils.getBigDecimal(divisor), Optional.ofNullable((MathContext)this.monetaryContext.get(MathContext.class)).orElse(MathContext.DECIMAL64));
        return new RoundedMoney((Number)dec, this.currency, this.rounding);
    }

    public RoundedMoney multiply(Number multiplicand) {
        BigDecimal bd = MoneyUtils.getBigDecimal(multiplicand);
        if (this.isOne(bd)) {
            return this;
        }
        BigDecimal dec = this.number.multiply(bd, Optional.ofNullable((MathContext)this.monetaryContext.get(MathContext.class)).orElse(MathContext.DECIMAL64));
        return new RoundedMoney((Number)dec, this.currency, this.rounding).with(this.rounding);
    }

    public RoundedMoney negate() {
        return new RoundedMoney((Number)this.number.negate(Optional.ofNullable((MathContext)this.monetaryContext.get(MathContext.class)).orElse(MathContext.DECIMAL64)), this.currency, this.rounding);
    }

    public RoundedMoney plus() {
        return this;
    }

    public RoundedMoney subtract(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        if (amount.isZero()) {
            return this;
        }
        return new RoundedMoney((Number)this.number.subtract((BigDecimal)amount.getNumber().numberValue(BigDecimal.class), Optional.ofNullable((MathContext)this.monetaryContext.get(MathContext.class)).orElse(MathContext.DECIMAL64)), this.currency, this.rounding);
    }

    public RoundedMoney pow(int n) {
        return new RoundedMoney((Number)this.number.pow(n, Optional.ofNullable((MathContext)this.monetaryContext.get(MathContext.class)).orElse(MathContext.DECIMAL64)), this.currency, this.rounding).with(this.rounding);
    }

    public RoundedMoney ulp() {
        return new RoundedMoney((Number)this.number.ulp(), this.currency, this.rounding);
    }

    public RoundedMoney remainder(Number divisor) {
        return new RoundedMoney((Number)this.number.remainder(MoneyUtils.getBigDecimal(divisor), Optional.ofNullable((MathContext)this.monetaryContext.get(MathContext.class)).orElse(MathContext.DECIMAL64)), this.currency, this.rounding);
    }

    public RoundedMoney scaleByPowerOfTen(int power) {
        return new RoundedMoney((Number)this.number.scaleByPowerOfTen(power), this.currency, this.rounding);
    }

    public boolean isZero() {
        return this.number.signum() == 0;
    }

    public boolean isPositive() {
        return this.signum() == 1;
    }

    public boolean isPositiveOrZero() {
        return this.signum() >= 0;
    }

    public boolean isNegative() {
        return this.signum() == -1;
    }

    public boolean isNegativeOrZero() {
        return this.signum() <= 0;
    }

    public RoundedMoney with(Number amount) {
        this.checkNumber(amount);
        return new RoundedMoney((Number)MoneyUtils.getBigDecimal(amount), this.currency, this.rounding);
    }

    public RoundedMoney with(CurrencyUnit currency) {
        Objects.requireNonNull(currency, "currency required");
        return new RoundedMoney((Number)this.asType(BigDecimal.class), currency, this.rounding);
    }

    public RoundedMoney with(CurrencyUnit currency, Number amount) {
        this.checkNumber(amount);
        return new RoundedMoney((Number)MoneyUtils.getBigDecimal(amount), currency, this.rounding);
    }

    public int getScale() {
        return this.number.scale();
    }

    public int getPrecision() {
        return this.number.precision();
    }

    public int signum() {
        return this.number.signum();
    }

    public boolean isLessThan(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) < 0;
    }

    public boolean isLessThanOrEqualTo(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) <= 0;
    }

    public boolean isGreaterThan(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) > 0;
    }

    public boolean isGreaterThanOrEqualTo(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) >= 0;
    }

    public boolean isEqualTo(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) == 0;
    }

    public boolean isNotEqualTo(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) != 0;
    }

    public RoundedMoney with(MonetaryOperator operator) {
        Objects.requireNonNull(operator);
        try {
            return RoundedMoney.from(operator.apply((MonetaryAmount)this));
        }
        catch (ArithmeticException | MonetaryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MonetaryException("Query failed: " + operator, (Throwable)e);
        }
    }

    public static RoundedMoney from(MonetaryAmount amt) {
        if (amt.getClass() == RoundedMoney.class) {
            return (RoundedMoney)amt;
        }
        if (amt.getClass() == FastMoney.class) {
            return RoundedMoney.of((BigDecimal)amt.getNumber().numberValue(BigDecimal.class), amt.getCurrency());
        }
        if (amt.getClass() == Money.class) {
            return RoundedMoney.of((BigDecimal)amt.getNumber().numberValue(BigDecimal.class), amt.getCurrency());
        }
        return RoundedMoney.of((BigDecimal)amt.getNumber().numberValue(BigDecimal.class), amt.getCurrency());
    }

    public static RoundedMoney parse(CharSequence text) {
        return RoundedMoney.parse(text, DEFAULT_FORMATTER);
    }

    public static RoundedMoney parse(CharSequence text, MonetaryAmountFormat formatter) {
        return RoundedMoney.from(formatter.parse(text));
    }

    public <T> T query(MonetaryQuery<T> query) {
        Objects.requireNonNull(query);
        try {
            return (T)query.queryFrom((MonetaryAmount)this);
        }
        catch (ArithmeticException | MonetaryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MonetaryException("Query failed: " + query, (Throwable)e);
        }
    }

    @Deprecated
    public <T> T asType(Class<T> type) {
        if (BigDecimal.class.equals(type)) {
            return (T)this.number;
        }
        if (Number.class.equals(type)) {
            return (T)this.number;
        }
        if (Double.class.equals(type)) {
            return (T)Double.valueOf(this.number.doubleValue());
        }
        if (Float.class.equals(type)) {
            return (T)Float.valueOf(this.number.floatValue());
        }
        if (Long.class.equals(type)) {
            return (T)Long.valueOf(this.number.longValue());
        }
        if (Integer.class.equals(type)) {
            return (T)Integer.valueOf(this.number.intValue());
        }
        if (Short.class.equals(type)) {
            return (T)Short.valueOf(this.number.shortValue());
        }
        if (Byte.class.equals(type)) {
            return (T)Byte.valueOf(this.number.byteValue());
        }
        if (BigInteger.class.equals(type)) {
            return (T)this.number.toBigInteger();
        }
        throw new IllegalArgumentException("Unsupported representation type: " + type);
    }

    @Deprecated
    public <T> T asType(Class<T> type, MonetaryOperator adjuster) {
        RoundedMoney amount = (RoundedMoney)adjuster.apply((MonetaryAmount)this);
        return amount.asType(type);
    }

    public String toString() {
        return this.currency.getCurrencyCode() + ' ' + this.number;
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.asNumberStripped());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RoundedMoney) {
            RoundedMoney other = (RoundedMoney)obj;
            return Objects.equals(this.currency, other.currency) && Objects.equals(this.asNumberStripped(), other.asNumberStripped());
        }
        return false;
    }

    @Override
    public int compareTo(MonetaryAmount o) {
        Objects.requireNonNull(o);
        int compare = this.currency.equals(o.getCurrency()) ? this.asNumberStripped().compareTo(RoundedMoney.from(o).asNumberStripped()) : this.currency.getCurrencyCode().compareTo(o.getCurrency().getCurrencyCode());
        return compare;
    }

    public NumberValue getNumber() {
        return new DefaultNumberValue(this.number);
    }

    public BigDecimal asNumberStripped() {
        if (this.isZero()) {
            return BigDecimal.ZERO;
        }
        return this.number.stripTrailingZeros();
    }

    private void checkNumber(Number number) {
        Objects.requireNonNull(number, "Number is required.");
    }

    public RoundedMoney multiply(long multiplicand) {
        if (multiplicand == 1L) {
            return this;
        }
        return this.multiply(MoneyUtils.getBigDecimal(multiplicand));
    }

    public RoundedMoney multiply(double multiplicand) {
        NumberVerifier.checkNoInfinityOrNaN(multiplicand);
        if (multiplicand == 1.0) {
            return this;
        }
        return this.multiply(MoneyUtils.getBigDecimal(multiplicand));
    }

    public RoundedMoney divide(long divisor) {
        if (divisor == 1L) {
            return this;
        }
        return this.divide(MoneyUtils.getBigDecimal(divisor));
    }

    public RoundedMoney divide(double divisor) {
        if (NumberVerifier.isInfinityAndNotNaN(divisor)) {
            return new RoundedMoney(0L, this.getCurrency(), this.monetaryContext, this.rounding);
        }
        if (divisor == 1.0) {
            return this;
        }
        return this.divide(MoneyUtils.getBigDecimal(divisor));
    }

    public RoundedMoney remainder(long divisor) {
        return this.remainder(MoneyUtils.getBigDecimal(divisor));
    }

    public RoundedMoney remainder(double divisor) {
        if (NumberVerifier.isInfinityAndNotNaN(divisor)) {
            return new RoundedMoney(0L, this.getCurrency(), this.monetaryContext, this.rounding);
        }
        return this.remainder(MoneyUtils.getBigDecimal(divisor));
    }

    public RoundedMoney[] divideAndRemainder(long divisor) {
        return this.divideAndRemainder(MoneyUtils.getBigDecimal(divisor));
    }

    public RoundedMoney[] divideAndRemainder(double divisor) {
        if (NumberVerifier.isInfinityAndNotNaN(divisor)) {
            RoundedMoney zero = new RoundedMoney(0L, this.getCurrency(), this.monetaryContext, this.rounding);
            return new RoundedMoney[]{zero, zero};
        }
        return this.divideAndRemainder(MoneyUtils.getBigDecimal(divisor));
    }

    public RoundedMoney stripTrailingZeros() {
        if (this.isZero()) {
            return RoundedMoney.of(BigDecimal.ZERO, this.getCurrency());
        }
        return RoundedMoney.of(this.number.stripTrailingZeros(), this.getCurrency());
    }

    public RoundedMoney divideToIntegralValue(long divisor) {
        return this.divideToIntegralValue(MoneyUtils.getBigDecimal(divisor));
    }

    public RoundedMoney divideToIntegralValue(double divisor) {
        return this.divideToIntegralValue(MoneyUtils.getBigDecimal(divisor));
    }

    public MonetaryAmountFactory<RoundedMoney> getFactory() {
        return new RoundedMoneyAmountFactory().setAmount(this);
    }

    private boolean isOne(Number number) {
        BigDecimal bd = MoneyUtils.getBigDecimal(number);
        try {
            return bd.scale() == 0 && bd.longValueExact() == 1L;
        }
        catch (Exception e) {
            return false;
        }
    }
}

