/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyQuery;
import javax.money.CurrencyUnit;
import javax.money.spi.CurrencyProviderSpi;
import org.javamoney.moneta.internal.JDKCurrencyAdapter;

public class JDKCurrencyProvider
implements CurrencyProviderSpi {
    private static final Map<String, CurrencyUnit> CACHED = JDKCurrencyProvider.loadCurrencies();

    private static Map<String, CurrencyUnit> loadCurrencies() {
        Set<Currency> availableCurrencies = Currency.getAvailableCurrencies();
        HashMap<String, JDKCurrencyAdapter> result = new HashMap<String, JDKCurrencyAdapter>(availableCurrencies.size());
        for (Currency jdkCurrency : availableCurrencies) {
            JDKCurrencyAdapter cu = new JDKCurrencyAdapter(jdkCurrency);
            result.put(cu.getCurrencyCode(), cu);
        }
        return Collections.unmodifiableMap(result);
    }

    public String getProviderName() {
        return "default";
    }

    public Set<CurrencyUnit> getCurrencies(CurrencyQuery currencyQuery) {
        HashSet<CurrencyUnit> result = new HashSet<CurrencyUnit>();
        if (!currencyQuery.getCurrencyCodes().isEmpty()) {
            for (String code : currencyQuery.getCurrencyCodes()) {
                CurrencyUnit cu = CACHED.get(code);
                if (cu == null) continue;
                result.add(cu);
            }
            return result;
        }
        if (!currencyQuery.getCountries().isEmpty()) {
            for (Locale country : currencyQuery.getCountries()) {
                CurrencyUnit cu = this.getCurrencyUnit(country);
                if (cu == null) continue;
                result.add(cu);
            }
            return result;
        }
        if (!currencyQuery.getNumericCodes().isEmpty()) {
            for (Integer numCode : currencyQuery.getNumericCodes()) {
                List<CurrencyUnit> cus = this.getCurrencyUnits(numCode);
                result.addAll(cus);
            }
            return result;
        }
        result.addAll(CACHED.values());
        return result;
    }

    private List<CurrencyUnit> getCurrencyUnits(int numCode) {
        ArrayList<CurrencyUnit> result = new ArrayList<CurrencyUnit>();
        for (Currency currency : Currency.getAvailableCurrencies()) {
            if (currency.getNumericCode() != numCode) continue;
            result.add(CACHED.get(currency.getCurrencyCode()));
        }
        return result;
    }

    private CurrencyUnit getCurrencyUnit(Locale locale) {
        block3: {
            try {
                Currency cur = Currency.getInstance(locale);
                if (Objects.nonNull(cur)) {
                    return CACHED.get(cur.getCurrencyCode());
                }
            }
            catch (Exception e) {
                if (!Logger.getLogger(this.getClass().getName()).isLoggable(Level.FINEST)) break block3;
                Logger.getLogger(this.getClass().getName()).finest("No currency for locale found: " + locale);
            }
        }
        return null;
    }
}

