/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal.format;

import java.io.IOException;
import java.util.Currency;
import java.util.Locale;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.MonetaryException;
import javax.money.format.MonetaryParseException;
import org.javamoney.moneta.format.CurrencyStyle;
import org.javamoney.moneta.internal.format.FormatToken;
import org.javamoney.moneta.internal.format.ParseContext;

final class CurrencyToken
implements FormatToken {
    private CurrencyStyle style = CurrencyStyle.CODE;
    private final Locale locale;

    CurrencyToken(CurrencyStyle style, Locale locale) {
        Objects.requireNonNull(locale, "Locale null");
        this.locale = locale;
        if (Objects.nonNull((Object)style)) {
            this.style = style;
        }
    }

    public CurrencyToken setCurrencyStyle(CurrencyStyle style) {
        Objects.requireNonNull(style, "CurrencyStyle null");
        this.style = style;
        return this;
    }

    public CurrencyStyle getCurrencyStyle() {
        return this.style;
    }

    private String getToken(MonetaryAmount amount) {
        switch (this.style) {
            case NUMERIC_CODE: {
                return String.valueOf(amount.getCurrency().getNumericCode());
            }
            case NAME: {
                return this.getCurrencyName(amount.getCurrency());
            }
            case SYMBOL: {
                return this.getCurrencySymbol(amount.getCurrency());
            }
        }
        return amount.getCurrency().getCurrencyCode();
    }

    private String getCurrencyName(CurrencyUnit currency) {
        Currency jdkCurrency = this.getCurrency(currency.getCurrencyCode());
        if (Objects.nonNull(jdkCurrency)) {
            return jdkCurrency.getDisplayName(this.locale);
        }
        return currency.getCurrencyCode();
    }

    private Currency getCurrency(String currencyCode) {
        try {
            return Currency.getInstance(currencyCode);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getCurrencySymbol(CurrencyUnit currency) {
        Currency jdkCurrency = this.getCurrency(currency.getCurrencyCode());
        if (Objects.nonNull(jdkCurrency)) {
            if ("BG".equals(this.locale.getCountry())) {
                return "\u043b\u0432";
            }
            return jdkCurrency.getSymbol(this.locale);
        }
        return currency.getCurrencyCode();
    }

    @Override
    public void parse(ParseContext context) throws MonetaryParseException {
        String token = context.lookupNextToken();
        while (Objects.nonNull(token) && token.trim().isEmpty()) {
            context.consume(token);
            token = context.lookupNextToken();
        }
        if (token == null) {
            throw new MonetaryException("Error parsing CurrencyUnit: no input.");
        }
        try {
            CurrencyUnit cur;
            switch (this.style) {
                case CODE: {
                    if (!Monetary.isCurrencyAvailable((String)token, (String[])new String[0])) {
                        String subCurrency = this.parseCurrencyCode(token);
                        cur = Monetary.getCurrency((String)subCurrency, (String[])new String[0]);
                        context.consume(subCurrency);
                        break;
                    }
                    cur = Monetary.getCurrency((String)token, (String[])new String[0]);
                    context.consume(token);
                    break;
                }
                case SYMBOL: {
                    if (token.startsWith("$")) {
                        throw new MonetaryParseException("$ is not a unique currency symbol.", (CharSequence)token, context.getErrorIndex());
                    }
                    if (token.startsWith("\u20ac")) {
                        cur = Monetary.getCurrency((String)"EUR", (String[])new String[0]);
                        context.consume("\u20ac");
                    } else if (token.startsWith("\u00a3")) {
                        cur = Monetary.getCurrency((String)"GBP", (String[])new String[0]);
                        context.consume("\u00a3");
                    } else {
                        cur = Monetary.getCurrency((String)token, (String[])new String[0]);
                        context.consume(token);
                    }
                    context.setParsedCurrency(cur);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not yet implemented");
                }
            }
            if (Objects.nonNull(cur)) {
                context.setParsedCurrency(cur);
            }
        }
        catch (Exception e) {
            throw new MonetaryException("Error parsing CurrencyUnit.", (Throwable)e);
        }
    }

    private String parseCurrencyCode(String token) {
        int letterIndex = 0;
        for (char ch : token.toCharArray()) {
            if (Character.isLetter(ch)) {
                ++letterIndex;
                continue;
            }
            return token.substring(0, letterIndex);
        }
        return token;
    }

    @Override
    public void print(Appendable appendable, MonetaryAmount amount) throws IOException {
        appendable.append(this.getToken(amount));
    }

    public String toString() {
        return "CurrencyToken [locale=" + this.locale + ", style=" + (Object)((Object)this.style) + ']';
    }
}

