/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.client.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.javaswift.joss.model.ListSubject;
import org.javaswift.joss.model.PaginationMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPaginationMap<Child extends ListSubject>
implements PaginationMap {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractPaginationMap.class);
    private int blockSize;
    private int pageSize;
    private Map<Integer, String> pageToMarker = new TreeMap<Integer, String>();
    private int numberOfRecords = 0;
    private String prefix;

    public AbstractPaginationMap(String prefix, int pageSize, int maxPageSize) {
        this.blockSize = maxPageSize;
        this.prefix = prefix;
        this.pageSize = pageSize;
    }

    public AbstractPaginationMap buildMap() {
        this.listAllItems();
        return this;
    }

    public abstract Collection<Child> list(String var1, String var2, int var3);

    public abstract int getCount();

    public Collection<Child> listAllItems() {
        ArrayList<Child> allChildren = new ArrayList<Child>();
        boolean loopUntilNoMoreData = false;
        int recordsToGo = this.getCount();
        String marker = null;
        int page = 0;
        int locationInPage = 0;
        this.pageToMarker.put(page++, null);
        if (recordsToGo == 0) {
            loopUntilNoMoreData = true;
            recordsToGo = 1;
        }
        while (recordsToGo > 0) {
            Collection<Child> children = this.list(this.prefix, marker, this.blockSize);
            for (ListSubject child : children) {
                marker = child.getName();
                ++this.numberOfRecords;
                if (++locationInPage != this.getPageSize()) continue;
                this.pageToMarker.put(page++, marker);
                locationInPage = 0;
            }
            if (children.isEmpty()) {
                recordsToGo = 0;
                continue;
            }
            allChildren.addAll(children);
            if (loopUntilNoMoreData) continue;
            recordsToGo -= children.size() < this.blockSize ? children.size() : this.blockSize;
        }
        if (locationInPage == 0) {
            this.pageToMarker.remove(this.pageToMarker.size() - 1);
        }
        LOG.info("JOSS / Created PaginationMap with " + this.pageToMarker.size() + " pages for a total of " + this.numberOfRecords + " records");
        return allChildren;
    }

    @Override
    public String getMarker(Integer page) {
        return this.pageToMarker.get(page);
    }

    @Override
    public int getNumberOfPages() {
        return this.pageToMarker.size();
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    public AbstractPaginationMap setBlockSize(int blockSize) {
        this.blockSize = blockSize;
        return this;
    }
}

