/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.headers.account;

import java.util.Date;
import org.apache.http.HttpResponse;
import org.apache.http.impl.cookie.DateParseException;
import org.javaswift.joss.exception.CommandException;
import org.javaswift.joss.headers.DateHeader;

public class ServerDate
extends DateHeader {
    public static String DATE = "Date";

    public ServerDate(Long milliseconds) {
        super(milliseconds);
    }

    public ServerDate(String date) throws DateParseException {
        super(date);
    }

    public ServerDate(Date date) {
        super(date);
    }

    @Override
    public String getHeaderValue() {
        return Long.toString(this.getDate().getTime());
    }

    @Override
    public String getHeaderName() {
        return DATE;
    }

    public static ServerDate fromResponse(HttpResponse response) {
        String serverDate = ServerDate.convertResponseHeader(response, DATE);
        try {
            return new ServerDate(serverDate);
        }
        catch (DateParseException err) {
            throw new CommandException(err.getMessage());
        }
    }
}

