/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.instructions;

import java.io.File;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.FileEntity;
import org.javaswift.joss.headers.object.Etag;
import org.javaswift.joss.instructions.SegmentationPlan;
import org.javaswift.joss.instructions.SegmentationPlanFile;
import org.javaswift.joss.instructions.UploadPayload;

public class UploadPayloadFile
extends UploadPayload {
    private File file;

    public UploadPayloadFile(File file) {
        this.file = file;
    }

    @Override
    public HttpEntity getEntity() {
        return new FileEntity(this.file);
    }

    @Override
    public boolean mustBeSegmented(Long segmentationSize) {
        return this.file.length() > segmentationSize;
    }

    @Override
    public Etag getEtag() throws IOException {
        return new Etag(this.getEntity().getContent());
    }

    @Override
    public SegmentationPlan getSegmentationPlan(Long segmentationSize) throws IOException {
        return new SegmentationPlanFile(this.file, segmentationSize);
    }
}

