/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.changelog;

import org.javers.core.changelog.AbstractTextChangeLog;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.changetype.NewObject;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.javers.core.diff.changetype.ReferenceChange;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.diff.changetype.container.ArrayChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.diff.changetype.container.SetChange;
import org.javers.core.diff.changetype.map.MapChange;
import org.javers.core.metamodel.object.GlobalId;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SimpleTextChangeLog
extends AbstractTextChangeLog {
    public static final DateTimeFormatter DEFAULT_DATE_FORMATTER = DateTimeFormat.mediumDateTime();
    private final DateTimeFormatter dateTimeFormatter;

    public SimpleTextChangeLog() {
        this(DEFAULT_DATE_FORMATTER);
    }

    public SimpleTextChangeLog(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public void onCommit(CommitMetadata commitMetadata) {
        this.appendln("commit " + commitMetadata.getId() + ", author: " + commitMetadata.getAuthor() + ", " + DEFAULT_DATE_FORMATTER.print((ReadablePartial)commitMetadata.getCommitDate()));
    }

    @Override
    public void onAffectedObject(GlobalId globalId) {
        this.appendln("  changed object: " + globalId.value());
    }

    @Override
    public void onValueChange(ValueChange valueChange) {
        this.appendln("    value changed on '" + valueChange.getProperty().getName() + "' property: '" + valueChange.getLeft() + "' -> '" + valueChange.getRight() + "'");
    }

    @Override
    public void onReferenceChange(ReferenceChange referenceChange) {
        this.appendln("    reference changed on '" + referenceChange.getProperty().getName() + "' property: '" + referenceChange.getLeft() + "' -> '" + referenceChange.getRight() + "'");
    }

    @Override
    public void onNewObject(NewObject newObject) {
        this.appendln("    new object: " + newObject.getAffectedGlobalId());
    }

    @Override
    public void onObjectRemoved(ObjectRemoved objectRemoved) {
        this.appendln("    object removed: '" + objectRemoved.getAffectedGlobalId());
    }

    @Override
    public void onMapChange(MapChange mapChange) {
        this.appendln("    map changed on '" + mapChange.getProperty().getName() + "' property: " + mapChange.getEntryChanges());
    }

    @Override
    public void onArrayChange(ArrayChange arrayChange) {
        this.appendln("    array changed on '" + arrayChange.getProperty().getName() + "' property: " + arrayChange.getChanges());
    }

    @Override
    public void onListChange(ListChange listChange) {
        this.appendln("    list changed on '" + listChange.getProperty().getName() + "' property: " + listChange.getChanges());
    }

    @Override
    public void onSetChange(SetChange setChange) {
        this.appendln("    set changed on '" + setChange.getProperty().getName() + "' property: " + setChange.getChanges());
    }
}

