/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ValueObject;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.UnboundedValueObjectId;

public class ValueObjectId
extends UnboundedValueObjectId {
    private final GlobalId ownerId;
    private final String fragment;

    public ValueObjectId(ValueObject valueObject, GlobalId ownerId, String fragment) {
        super(valueObject);
        Validate.argumentsAreNotNull(ownerId, fragment);
        this.ownerId = ownerId;
        this.fragment = fragment;
    }

    public ValueObjectId(ValueObject valueObject, OwnerContext ownerContext) {
        this(valueObject, ownerContext.getGlobalId(), ownerContext.getPath());
    }

    @Override
    public String getFragment() {
        return this.fragment;
    }

    public GlobalId getOwnerId() {
        return this.ownerId;
    }

    @Override
    public String value() {
        return this.getOwnerId().value() + "#" + this.fragment;
    }
}

