/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.util.ArrayList;
import java.util.List;
import org.javers.common.reflection.JaversField;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.metamodel.clazz.AnnotationNamesProvider;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.property.PropertyScanner;

public class FieldBasedPropertyScanner
implements PropertyScanner {
    private final AnnotationNamesProvider annotationNamesProvider;

    public FieldBasedPropertyScanner(AnnotationNamesProvider annotationNamesProvider) {
        this.annotationNamesProvider = annotationNamesProvider;
    }

    @Override
    public List<Property> scan(Class<?> managedClass) {
        List<JaversField> fields = ReflectionUtil.getAllPersistentFields(managedClass);
        ArrayList<Property> propertyList = new ArrayList<Property>(fields.size());
        for (JaversField field : fields) {
            boolean hasTransientAnn = field.hasAnyAnnotation(this.annotationNamesProvider.getTransientAliases());
            propertyList.add(new Property(field, hasTransientAnn));
        }
        return propertyList;
    }
}

