/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.ArrayList;
import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.graph.LiveGraph;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.SnapshotFactory;
import org.javers.core.snapshot.ShadowGraph;

class GraphSnapshotFactory {
    private final SnapshotFactory snapshotFactory;

    GraphSnapshotFactory(SnapshotFactory snapshotFactory) {
        this.snapshotFactory = snapshotFactory;
    }

    List<CdoSnapshot> create(LiveGraph currentVersion, ShadowGraph latestShadowGraph, CommitMetadata commitMetadata) {
        Validate.argumentsAreNotNull(currentVersion, commitMetadata, latestShadowGraph);
        ArrayList<CdoSnapshot> result = new ArrayList<CdoSnapshot>();
        for (ObjectNode node : currentVersion.nodes()) {
            boolean initial = this.isInitial(node, latestShadowGraph);
            Optional<CdoSnapshot> existing = latestShadowGraph.get(node.getGlobalId());
            CdoSnapshot fresh = this.createFreshSnapshot(initial, node, commitMetadata, existing);
            if (existing.isEmpty()) {
                result.add(fresh);
                continue;
            }
            if (existing.get().stateEquals(fresh)) continue;
            result.add(fresh);
        }
        return result;
    }

    private CdoSnapshot createFreshSnapshot(boolean initial, ObjectNode node, CommitMetadata commitMetadata, Optional<CdoSnapshot> previous) {
        Object liveCdo = node.wrappedCdo().get();
        if (initial) {
            return this.snapshotFactory.createInitial(liveCdo, node.getGlobalId(), commitMetadata);
        }
        return this.snapshotFactory.createUpdate(liveCdo, previous.get(), commitMetadata);
    }

    private boolean isInitial(ObjectNode node, ShadowGraph latestShadowGraph) {
        return !latestShadowGraph.contains(node);
    }
}

