/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter.change;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Optional;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.json.typeadapter.change.ChangeTypeAdapter;
import org.javers.core.metamodel.type.TypeMapper;

class ValueChangeTypeAdapter
extends ChangeTypeAdapter<ValueChange> {
    private static final String LEFT_VALUE_FIELD = "left";
    private static final String RIGHT_VALUE_FIELD = "right";

    public ValueChangeTypeAdapter(TypeMapper typeMapper) {
        super(typeMapper);
    }

    @Override
    public ValueChange fromJson(JsonElement json, JsonDeserializationContext context) {
        JsonObject jsonObject = (JsonObject)json;
        ChangeTypeAdapter.PropertyChangeStub stub = this.deserializeStub(jsonObject, context);
        Object leftValue = context.deserialize(jsonObject.get(LEFT_VALUE_FIELD), stub.property.getGenericType());
        Object rightValue = context.deserialize(jsonObject.get(RIGHT_VALUE_FIELD), stub.property.getGenericType());
        CommitMetadata commitMetadata = this.deserializeCommitMetadata(jsonObject, context);
        return new ValueChange(stub.id, stub.getPropertyName(), leftValue, rightValue, Optional.ofNullable(commitMetadata));
    }

    @Override
    public JsonElement toJson(ValueChange change, JsonSerializationContext context) {
        JsonObject jsonObject = this.createJsonObject(change, context);
        jsonObject.add(LEFT_VALUE_FIELD, context.serialize(change.getLeft()));
        jsonObject.add(RIGHT_VALUE_FIELD, context.serialize(change.getRight()));
        return jsonObject;
    }

    @Override
    public Class getValueType() {
        return ValueChange.class;
    }
}

