/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.javers.common.reflection.JaversGetter;
import org.javers.common.reflection.TypeResolvingContext;

class JaversGetterFactory {
    private final Class getterSource;

    JaversGetterFactory(Class getterSource) {
        this.getterSource = getterSource;
    }

    List<JaversGetter> getAllGetters() {
        ArrayList<JaversGetter> getters = new ArrayList<JaversGetter>();
        TypeResolvingContext context = new TypeResolvingContext();
        for (Class clazz = this.getterSource; clazz != Object.class; clazz = clazz.getSuperclass()) {
            context.addTypeSubstitutions(clazz);
            Arrays.stream(clazz.getDeclaredMethods()).filter(method -> JaversGetterFactory.isGetter(method) && !method.isBridge()).map(getterMethod -> this.createJaversGetter((Method)getterMethod, context)).forEach(getters::add);
        }
        return getters;
    }

    private static boolean isGetter(Method rawMethod) {
        return JaversGetterFactory.hasGetOrIsPrefix(rawMethod) && JaversGetterFactory.hasNoParamters(rawMethod) && JaversGetterFactory.returnsSomething(rawMethod) && JaversGetterFactory.isNotStatic(rawMethod) && JaversGetterFactory.isNotAbstract(rawMethod) && JaversGetterFactory.isNotNative(rawMethod);
    }

    private static boolean hasGetOrIsPrefix(Method rawMethod) {
        return rawMethod.getName().startsWith("get") || rawMethod.getName().startsWith("is");
    }

    private static boolean hasNoParamters(Method rawMethod) {
        return rawMethod.getParameterTypes().length == 0;
    }

    private static boolean returnsSomething(Method rawMethod) {
        return rawMethod.getGenericReturnType() != Void.TYPE;
    }

    private static boolean isNotStatic(Method rawMethod) {
        return !Modifier.isStatic(rawMethod.getModifiers());
    }

    private static boolean isNotAbstract(Method rawMethod) {
        return !Modifier.isAbstract(rawMethod.getModifiers());
    }

    private static boolean isNotNative(Method rawMethod) {
        return !Modifier.isNative(rawMethod.getModifiers());
    }

    private JaversGetter createJaversGetter(Method getterMethod, TypeResolvingContext context) {
        Type actualReturnType = context.getSubstitution(getterMethod.getGenericReturnType());
        return new JaversGetter(getterMethod, actualReturnType);
    }
}

