/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.metamodel.clazz.EntityDefinition;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.ManagedClass;
import org.javers.core.metamodel.type.ManagedClassFactory;
import org.javers.core.metamodel.type.ShallowReferenceType;

class EntityTypeFactory {
    private final ManagedClassFactory managedClassFactory;

    EntityTypeFactory(ManagedClassFactory managedClassFactory) {
        this.managedClassFactory = managedClassFactory;
    }

    EntityType createEntity(EntityDefinition definition) {
        ManagedClass managedClass = this.managedClassFactory.create(definition);
        JaversProperty idProperty = definition.hasCustomId() ? managedClass.getProperty(definition.getIdPropertyName()) : this.findDefaultIdProperty(managedClass, definition.isShallowReference());
        if (definition.isShallowReference()) {
            return new ShallowReferenceType(managedClass, idProperty, definition.getTypeName());
        }
        return new EntityType(managedClass, idProperty, definition.getTypeName());
    }

    private JaversProperty findDefaultIdProperty(ManagedClass managedClass, boolean isShallowReference) {
        if (managedClass.getLooksLikeId().isEmpty()) {
            JaversExceptionCode code = isShallowReference ? JaversExceptionCode.SHALLOW_REF_ENTITY_WITHOUT_ID : JaversExceptionCode.ENTITY_WITHOUT_ID;
            throw new JaversException(code, managedClass.getBaseJavaClass().getName());
        }
        return managedClass.getLooksLikeId().get(0);
    }
}

