/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.json.typeadapter.util.FileTypeAdapter;
import org.javers.core.json.typeadapter.util.JavaSqlDateTypeAdapter;
import org.javers.core.json.typeadapter.util.JavaSqlTimeTypeAdapter;
import org.javers.core.json.typeadapter.util.JavaSqlTimestampTypeAdapter;
import org.javers.core.json.typeadapter.util.JavaUtilDateTypeAdapter;
import org.javers.core.json.typeadapter.util.UUIDTypeAdapter;

public class UtilTypeCoreAdapters {
    private static final DateTimeFormatter ISO_FORMAT = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    public static final ZoneId UTC = ZoneId.of("UTC");

    public static LocalDateTime deserialize(String date) {
        return LocalDateTime.parse(date, ISO_FORMAT);
    }

    public static Instant deserializeToInstant(String date) {
        return UtilTypeCoreAdapters.deserialize(date).toInstant(ZoneOffset.UTC);
    }

    public static String serialize(LocalDateTime date) {
        return date.format(ISO_FORMAT);
    }

    public static LocalDateTime fromUtilDate(Date date) {
        if (date.getClass() == Date.class) {
            return LocalDateTime.ofInstant(date.toInstant(), UTC);
        }
        return UtilTypeCoreAdapters.fromUtilDate(new Date(date.getTime()));
    }

    public static Date toUtilDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.toInstant(ZoneOffset.UTC));
    }

    public static String serialize(Date date) {
        return UtilTypeCoreAdapters.serialize(UtilTypeCoreAdapters.fromUtilDate(date));
    }

    public static List<JsonTypeAdapter> adapters() {
        return Lists.immutableListOf(new JavaUtilDateTypeAdapter(), new JavaSqlDateTypeAdapter(), new JavaSqlTimestampTypeAdapter(), new JavaSqlTimeTypeAdapter(), new FileTypeAdapter(), new UUIDTypeAdapter());
    }
}

