/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import org.javers.common.validation.Validate;

public class Sets {
    private Sets() {
    }

    public static <E> Set<E> intersection(Set<E> first, Set<E> second) {
        if (first == null || second == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<E> intersection = new HashSet<E>();
        for (E e : first) {
            if (!second.contains(e)) continue;
            intersection.add(e);
        }
        return intersection;
    }

    public static <E> Set<E> xor(Set<E> first, Set<E> second) {
        Set<E> xor = Sets.difference(first, second);
        xor.addAll(Sets.difference(second, first));
        return xor;
    }

    public static <E> Set<E> difference(Set<E> first, Set<E> second) {
        if (first == null) {
            return Collections.EMPTY_SET;
        }
        if (second == null) {
            return first;
        }
        HashSet<E> difference = new HashSet<E>(first);
        difference.removeAll(second);
        return difference;
    }

    public static <E> Set<E> asSet(E ... elements) {
        return Sets.asSet(Arrays.asList(elements));
    }

    public static <E> Set<E> asSet(Collection<E> elements) {
        if (elements == null) {
            return Collections.emptySet();
        }
        return new HashSet<E>(elements);
    }

    public static <F, T> Set<T> transform(Set<F> input, Function<F, T> transformation) {
        Validate.argumentsAreNotNull(input, transformation);
        return input.stream().map(transformation::apply).collect(Sets.toImmutableSet());
    }

    private static <E> Set<E> nullSafe(Set<E> set) {
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public static <T> Map<Integer, T> asMap(Set<T> input) {
        if (input == null) {
            return null;
        }
        HashMap<Integer, T> result = new HashMap<Integer, T>();
        int i = 0;
        for (T element : input) {
            result.put(i, element);
            ++i;
        }
        return result;
    }

    public static <t> Collector<t, Set<t>, Set<t>> toImmutableSet() {
        return Collector.of(HashSet::new, Set::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collections::unmodifiableSet, new Collector.Characteristics[0]);
    }
}

