/*
 * Decompiled with CFR 0.152.
 */
package org.javers.shadow;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.CdoSnapshotStateBuilder;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.shadow.ShadowBuilder;

class ShadowGraphBuilder {
    private final JsonConverter jsonConverter;
    private final BiFunction<CommitMetadata, GlobalId, CdoSnapshot> referenceResolver;
    private boolean built = false;
    private Map<GlobalId, ShadowBuilder> builtNodes = new HashMap<GlobalId, ShadowBuilder>();
    private final TypeMapper typeMapper;
    private final CommitMetadata rootContext;

    ShadowGraphBuilder(JsonConverter jsonConverter, BiFunction<CommitMetadata, GlobalId, CdoSnapshot> referenceResolver, TypeMapper typeMapper, CommitMetadata rootContext) {
        this.jsonConverter = jsonConverter;
        this.referenceResolver = referenceResolver;
        this.typeMapper = typeMapper;
        this.rootContext = rootContext;
    }

    Object buildDeepShadow(CdoSnapshot cdoSnapshot) {
        Validate.argumentIsNotNull(cdoSnapshot);
        this.switchToBuilt();
        ShadowBuilder root = this.assembleShadowStub(cdoSnapshot);
        this.doWiring();
        return root.getShadow();
    }

    private void doWiring() {
        this.builtNodes.values().forEach(ShadowBuilder::wire);
    }

    private void switchToBuilt() {
        if (this.built) {
            throw new IllegalStateException("already built");
        }
        this.built = true;
    }

    private ShadowBuilder assembleShallowReferenceShadow(InstanceId instanceId, EntityType shallowReferenceType) {
        CdoSnapshotState state = CdoSnapshotStateBuilder.cdoSnapshotState().withPropertyValue(shallowReferenceType.getIdProperty(), instanceId.getCdoId()).build();
        JsonObject jsonElement = (JsonObject)this.jsonConverter.toJsonElement(state);
        Object shadowStub = this.jsonConverter.fromJson((JsonElement)jsonElement, shallowReferenceType.getBaseJavaClass());
        ShadowBuilder shadowBuilder = new ShadowBuilder(null, shadowStub);
        this.builtNodes.put(instanceId, shadowBuilder);
        return shadowBuilder;
    }

    private ShadowBuilder assembleShadowStub(CdoSnapshot cdoSnapshot) {
        ShadowBuilder shadowBuilder = new ShadowBuilder(cdoSnapshot, null);
        this.builtNodes.put(cdoSnapshot.getGlobalId(), shadowBuilder);
        JsonObject jsonElement = (JsonObject)this.jsonConverter.toJsonElement(cdoSnapshot.getState());
        this.mapCustomPropertyNamesToJavaOrigin(cdoSnapshot, jsonElement);
        this.followReferences(shadowBuilder, jsonElement);
        Object shadowStub = this.jsonConverter.fromJson((JsonElement)jsonElement, cdoSnapshot.getManagedType().getBaseJavaClass());
        shadowBuilder.withStub(shadowStub);
        return shadowBuilder;
    }

    private void mapCustomPropertyNamesToJavaOrigin(CdoSnapshot cdoSnapshot, JsonObject jsonElement) {
        cdoSnapshot.getManagedType().forEachProperty(javersProperty -> {
            if (javersProperty.hasCustomName()) {
                JsonElement value = jsonElement.get(javersProperty.getName());
                jsonElement.remove(javersProperty.getName());
                jsonElement.add(javersProperty.getOriginalName(), value);
            }
        });
    }

    private void followReferences(ShadowBuilder currentNode, JsonObject jsonElement) {
        CdoSnapshot cdoSnapshot = currentNode.getCdoSnapshot();
        cdoSnapshot.getManagedType().forEachProperty(property -> {
            Object containerWithRefs;
            EnumerableType propertyType;
            if (cdoSnapshot.isNull((Property)property)) {
                return;
            }
            if (property.getType() instanceof ManagedType) {
                GlobalId refId = (GlobalId)cdoSnapshot.getPropertyValue((Property)property);
                ShadowBuilder target = this.createOrReuseNodeFromRef(refId, (JaversProperty)property);
                if (target != null) {
                    currentNode.addReferenceWiring((JaversProperty)property, target);
                }
                jsonElement.remove(property.getName());
            }
            if ((this.typeMapper.isContainerOfManagedTypes((JaversType)property.getType()) || this.typeMapper.isKeyValueTypeWithManagedTypes((JaversType)property.getType())) && !(propertyType = (EnumerableType)property.getType()).isEmpty(containerWithRefs = cdoSnapshot.getPropertyValue((Property)property))) {
                currentNode.addEnumerableWiring((JaversProperty)property, propertyType.map(containerWithRefs, value -> this.passValueOrCreateNodeFromRef(value, (JaversProperty)property)));
                jsonElement.remove(property.getName());
            }
        });
    }

    private Object passValueOrCreateNodeFromRef(Object value, JaversProperty property) {
        if (value instanceof GlobalId) {
            return this.createOrReuseNodeFromRef((GlobalId)value, property);
        }
        return value;
    }

    private ShadowBuilder createOrReuseNodeFromRef(GlobalId globalId, JaversProperty property) {
        if (this.builtNodes.containsKey(globalId)) {
            return this.builtNodes.get(globalId);
        }
        if (property.isShallowReference()) {
            return this.assembleShallowReferenceShadow((InstanceId)globalId, (EntityType)property.getType());
        }
        CdoSnapshot cdoSnapshot = this.referenceResolver.apply(this.rootContext, globalId);
        if (cdoSnapshot != null) {
            return this.assembleShadowStub(cdoSnapshot);
        }
        return null;
    }
}

