/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.ReferenceChange;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.OptionalType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;
import org.javers.core.metamodel.type.TypeMapper;

public class OptionalChangeAppender
implements PropertyChangeAppender<PropertyChange> {
    private final TypeMapper typeMapper;

    public OptionalChangeAppender(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof OptionalType;
    }

    @Override
    public PropertyChange calculateChanges(NodePair pair, JaversProperty property) {
        Optional rightOptional;
        OptionalType optionalType = (OptionalType)property.getType();
        JaversType contentType = this.typeMapper.getJaversType(optionalType.getItemType());
        Optional leftOptional = this.normalize((Optional)pair.getLeftDehydratedPropertyValueAndSanitize(property));
        if (Objects.equals(leftOptional, rightOptional = this.normalize((Optional)pair.getRightDehydratedPropertyValueAndSanitize(property)))) {
            return null;
        }
        if (contentType instanceof ManagedType) {
            return new ReferenceChange(pair.createPropertyChangeMetadata(property), this.first(pair.getLeftReferences(property)), this.first(pair.getRightReferences(property)), this.flat(pair.getLeftPropertyValue(property)), this.flat(pair.getRightPropertyValue(property)));
        }
        if (contentType instanceof PrimitiveOrValueType) {
            return new ValueChange(pair.createPropertyChangeMetadata(property), (Object)leftOptional, (Object)rightOptional);
        }
        throw new JaversException(JaversExceptionCode.UNSUPPORTED_OPTIONAL_CONTENT_TYPE, contentType);
    }

    private GlobalId first(List<GlobalId> refs) {
        if (refs != null && refs.size() > 0) {
            return refs.get(0);
        }
        return null;
    }

    private Object flat(Object optional) {
        if (optional instanceof Optional) {
            return ((Optional)optional).orElse(null);
        }
        return optional;
    }

    private Optional normalize(Optional optional) {
        if (optional == null) {
            return Optional.empty();
        }
        return optional;
    }
}

