/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter.commit;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.json.typeadapter.commit.GlobalIdTypeAdapter;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.CdoSnapshotStateBuilder;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;
import org.javers.core.metamodel.type.TokenType;
import org.javers.core.metamodel.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CdoSnapshotStateDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(CdoSnapshotStateDeserializer.class);
    private final TypeMapper typeMapper;
    private final JsonDeserializationContext context;

    public CdoSnapshotStateDeserializer(TypeMapper typeMapper, JsonDeserializationContext context) {
        this.typeMapper = typeMapper;
        this.context = context;
    }

    public CdoSnapshotState deserialize(JsonElement stateElement, ManagedType managedType) {
        Validate.argumentsAreNotNull(stateElement, managedType, this.context);
        JsonObject stateObject = (JsonObject)stateElement;
        CdoSnapshotStateBuilder builder = CdoSnapshotStateBuilder.cdoSnapshotState();
        stateObject.entrySet().stream().forEach(e -> builder.withPropertyValue((String)e.getKey(), this.decodePropertyValue((JsonElement)e.getValue(), this.context, managedType.findProperty((String)e.getKey()))));
        return builder.build();
    }

    private Object decodePropertyValue(JsonElement propertyElement, JsonDeserializationContext context, Optional<JaversProperty> javersPropertyOptional) {
        if (!javersPropertyOptional.isPresent()) {
            return this.decodePropertyValueUsingJsonType(propertyElement, context);
        }
        JaversProperty javersProperty = javersPropertyOptional.get();
        Object expectedJaversType = javersProperty.getType();
        if (this.unmatchedPrimitivesOnBothSides((JaversType)expectedJaversType, propertyElement)) {
            return this.decodePropertyValueUsingJsonType(propertyElement, context);
        }
        if (this.shouldUseBareContainerClass((JaversType)expectedJaversType, propertyElement)) {
            return context.deserialize(propertyElement, (Type)((ContainerType)expectedJaversType).getBaseJavaClass());
        }
        try {
            Type expectedJavaType = this.typeMapper.getDehydratedType(javersProperty.getGenericType());
            if (javersProperty.getType() instanceof TokenType) {
                return this.deserializeValueWithTypeGuessing(propertyElement, context);
            }
            return context.deserialize(propertyElement, expectedJavaType);
        }
        catch (JsonSyntaxException | DateTimeParseException e) {
            logger.info("Can't deserialize type-safely the Snapshot property: " + javersProperty + ". JSON value: " + propertyElement + ". Looks like a type mismatch after refactoring of " + javersProperty.getDeclaringClass().getSimpleName() + " class.");
            return this.decodePropertyValueUsingJsonType(propertyElement, context);
        }
    }

    private Object deserializeValueWithTypeGuessing(JsonElement propertyElement, JsonDeserializationContext context) {
        if (propertyElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)propertyElement;
            if (jsonPrimitive.isString()) {
                return jsonPrimitive.getAsString();
            }
            if (jsonPrimitive.isNumber()) {
                if (jsonPrimitive.getAsString().equals(jsonPrimitive.getAsInt() + "")) {
                    return jsonPrimitive.getAsInt();
                }
                if (jsonPrimitive.getAsString().equals(jsonPrimitive.getAsLong() + "")) {
                    return jsonPrimitive.getAsLong();
                }
            }
        }
        return context.deserialize(propertyElement, Object.class);
    }

    private boolean unmatchedPrimitivesOnBothSides(JaversType expectedJaversType, JsonElement propertyElement) {
        if (this.ifPrimitivesOnBothSides(expectedJaversType, propertyElement)) {
            return !this.matches((PrimitiveOrValueType)expectedJaversType, (JsonPrimitive)propertyElement);
        }
        return false;
    }

    private boolean ifPrimitivesOnBothSides(JaversType expectedJaversType, JsonElement propertyElement) {
        return expectedJaversType instanceof PrimitiveOrValueType && ((PrimitiveOrValueType)expectedJaversType).isJsonPrimitive() && propertyElement instanceof JsonPrimitive;
    }

    private boolean shouldUseBareContainerClass(JaversType expectedJaversType, JsonElement propertyElement) {
        if (!(expectedJaversType instanceof ContainerType) || !(propertyElement instanceof JsonArray)) {
            return false;
        }
        ContainerType expectedContainerType = (ContainerType)expectedJaversType;
        JsonArray propertyArray = (JsonArray)propertyElement;
        if (propertyArray.size() == 0) {
            return false;
        }
        JsonElement firstItem = propertyArray.get(0);
        JaversType itemType = this.typeMapper.getJaversType(expectedContainerType.getItemType());
        return this.unmatchedPrimitivesOnBothSides(itemType, firstItem);
    }

    private boolean matches(PrimitiveOrValueType javersPrimitive, JsonPrimitive jsonPrimitive) {
        return jsonPrimitive.isNumber() && javersPrimitive.isNumber() || jsonPrimitive.isString() && javersPrimitive.isStringy() || jsonPrimitive.isBoolean() && javersPrimitive.isBoolean();
    }

    private Object decodePropertyValueUsingJsonType(JsonElement propertyElement, JsonDeserializationContext context) {
        if (GlobalIdTypeAdapter.looksLikeGlobalId(propertyElement)) {
            return context.deserialize(propertyElement, GlobalId.class);
        }
        return context.deserialize(propertyElement, Object.class);
    }
}

