/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;

public abstract class Change
implements Serializable {
    private final CommitMetadata commitMetadata;
    private final GlobalId affectedCdoId;
    private transient Object affectedCdo;

    protected Change(GlobalId affectedCdoId, Optional<Object> affectedCdo) {
        this(affectedCdoId, affectedCdo, Optional.empty());
    }

    protected Change(GlobalId affectedCdoId, Optional<Object> affectedCdo, Optional<CommitMetadata> commitMetadata) {
        Validate.argumentsAreNotNull(affectedCdoId, affectedCdo, commitMetadata);
        this.affectedCdoId = affectedCdoId;
        affectedCdo.ifPresent(cdo -> {
            this.affectedCdo = cdo;
        });
        this.commitMetadata = commitMetadata.orElse(null);
    }

    public GlobalId getAffectedGlobalId() {
        return this.affectedCdoId;
    }

    public Object getAffectedLocalId() {
        if (this.affectedCdoId instanceof InstanceId) {
            return ((InstanceId)this.affectedCdoId).getCdoId();
        }
        return null;
    }

    public Optional<Object> getAffectedObject() {
        return Optional.ofNullable(this.affectedCdo);
    }

    public Optional<CommitMetadata> getCommitMetadata() {
        return Optional.ofNullable(this.commitMetadata);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ " + this.prettyPrint(PrettyValuePrinter.getDefault()) + " }";
    }

    public abstract String prettyPrint(PrettyValuePrinter var1);

    void setAffectedCdo(Object affectedCdo) {
        Validate.argumentIsNotNull(affectedCdo);
        Validate.conditionFulfilled(this.affectedCdo == null, "affectedCdo already set");
        this.affectedCdo = affectedCdo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Change) {
            Change that = (Change)obj;
            return Objects.equals(this.affectedCdoId, that.affectedCdoId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.affectedCdoId);
    }
}

