/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.javers.common.collections.Sets;
import org.javers.common.validation.Validate;
import org.javers.core.CoreConfiguration;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffFactory;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.snapshot.SnapshotGraph;
import org.javers.core.snapshot.SnapshotNode;
import org.javers.repository.api.SnapshotIdentifier;

public class SnapshotDiffer {
    private final DiffFactory diffFactory;
    private final CoreConfiguration javersCoreConfiguration;

    public SnapshotDiffer(DiffFactory diffFactory, CoreConfiguration javersCoreConfiguration) {
        this.diffFactory = diffFactory;
        this.javersCoreConfiguration = javersCoreConfiguration;
    }

    public List<Change> calculateDiffs(List<CdoSnapshot> snapshots, Map<SnapshotIdentifier, CdoSnapshot> previousSnapshots) {
        Validate.argumentsAreNotNull(snapshots);
        Validate.argumentsAreNotNull(previousSnapshots);
        ArrayList<Change> changes = new ArrayList<Change>();
        for (CdoSnapshot snapshot : snapshots) {
            CdoSnapshot previousSnapshot;
            if (snapshot.isInitial()) {
                changes.addAll(this.addInitialChanges(snapshot));
            }
            if (snapshot.isTerminal()) {
                previousSnapshot = previousSnapshots.get(SnapshotIdentifier.from(snapshot).previous());
                this.addTerminalChanges(changes, snapshot, previousSnapshot);
            }
            if (!snapshot.isUpdate()) continue;
            previousSnapshot = previousSnapshots.get(SnapshotIdentifier.from(snapshot).previous());
            this.addChanges(changes, previousSnapshot, snapshot);
        }
        return changes;
    }

    private List<Change> addInitialChanges(CdoSnapshot initialSnapshot) {
        Diff initialDiff = this.diffFactory.create(this.emptySnapshotGraph(), this.snapshotGraph(initialSnapshot), this.commitMetadata(initialSnapshot));
        return initialDiff.getChanges();
    }

    private void addTerminalChanges(List<Change> changes, CdoSnapshot terminalSnapshot, CdoSnapshot previousSnapshot) {
        changes.add(new ObjectRemoved(terminalSnapshot.getGlobalId(), Optional.empty(), Optional.of(terminalSnapshot.getCommitMetadata())));
        if (previousSnapshot != null && this.javersCoreConfiguration.isTerminalChanges()) {
            Diff terminalDiff = this.diffFactory.create(this.snapshotGraph(previousSnapshot), this.snapshotGraph(terminalSnapshot), this.commitMetadata(terminalSnapshot));
            changes.addAll(terminalDiff.getChanges());
        }
    }

    private void addChanges(List<Change> changes, CdoSnapshot previousSnapshot, CdoSnapshot currentSnapshot) {
        Diff diff = this.diffFactory.create(this.snapshotGraph(previousSnapshot), this.snapshotGraph(currentSnapshot), this.commitMetadata(currentSnapshot));
        changes.addAll(diff.getChanges());
    }

    private SnapshotGraph snapshotGraph(CdoSnapshot snapshot) {
        return new SnapshotGraph(Sets.asSet(new SnapshotNode(snapshot)));
    }

    private SnapshotGraph emptySnapshotGraph() {
        return new SnapshotGraph(Collections.emptySet());
    }

    private Optional<CommitMetadata> commitMetadata(CdoSnapshot snapshot) {
        return Optional.of(snapshot.getCommitMetadata());
    }
}

