/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.Changes;
import org.javers.core.CoreConfiguration;
import org.javers.core.Javers;
import org.javers.core.changelog.ChangeListTraverser;
import org.javers.core.changelog.ChangeProcessor;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitFactory;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffFactory;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.PrimitiveType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.ValueType;
import org.javers.repository.api.JaversExtendedRepository;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryRunner;
import org.javers.shadow.Shadow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JaversCore
implements Javers {
    private static final Logger logger = LoggerFactory.getLogger(Javers.class);
    private final DiffFactory diffFactory;
    private final TypeMapper typeMapper;
    private final JsonConverter jsonConverter;
    private final CommitFactory commitFactory;
    private final JaversExtendedRepository repository;
    private final QueryRunner queryRunner;
    private final GlobalIdFactory globalIdFactory;
    private final CoreConfiguration configuration;

    JaversCore(DiffFactory diffFactory, TypeMapper typeMapper, JsonConverter jsonConverter, CommitFactory commitFactory, JaversExtendedRepository repository, QueryRunner queryRunner, GlobalIdFactory globalIdFactory, CoreConfiguration javersCoreConfiguration) {
        this.diffFactory = diffFactory;
        this.typeMapper = typeMapper;
        this.jsonConverter = jsonConverter;
        this.commitFactory = commitFactory;
        this.repository = repository;
        this.queryRunner = queryRunner;
        this.globalIdFactory = globalIdFactory;
        this.configuration = javersCoreConfiguration;
    }

    @Override
    public Commit commit(String author, Object currentVersion) {
        return this.commit(author, currentVersion, Collections.emptyMap());
    }

    @Override
    public CompletableFuture<Commit> commitAsync(String author, Object currentVersion, Executor executor) {
        return this.commitAsync(author, currentVersion, Collections.emptyMap(), executor);
    }

    @Override
    public Commit commit(String author, Object currentVersion, Map<String, String> commitProperties) {
        long start = System.currentTimeMillis();
        Validate.argumentIsNotNull(author);
        Validate.argumentIsNotNull(commitProperties);
        Validate.argumentIsNotNull(currentVersion);
        this.assertJaversTypeNotValueTypeOrPrimitiveType(currentVersion);
        Commit commit = this.commitFactory.create(author, commitProperties, currentVersion);
        long stopCreate = System.currentTimeMillis();
        this.persist(commit);
        long stop = System.currentTimeMillis();
        logger.info(commit.toString() + ", done in " + (stop - start) + " millis (diff:{}, persist:{})", (Object)(stopCreate - start), (Object)(stop - stopCreate));
        return commit;
    }

    private void assertJaversTypeNotValueTypeOrPrimitiveType(Object currentVersion) {
        JaversType jType = this.typeMapper.getJaversType(currentVersion.getClass());
        if (jType instanceof ValueType || jType instanceof PrimitiveType) {
            throw new JaversException(JaversExceptionCode.COMMITTING_TOP_LEVEL_VALUES_NOT_SUPPORTED, jType.getClass().getSimpleName(), currentVersion.getClass().getSimpleName());
        }
    }

    private Commit persist(Commit commit) {
        if (commit.getSnapshots().isEmpty()) {
            logger.info("Skipping persisting empty commit: {}", (Object)commit.toString());
        } else {
            this.repository.persist(commit);
        }
        return commit;
    }

    @Override
    public CompletableFuture<Commit> commitAsync(String author, Object currentVersion, Map<String, String> commitProperties, Executor executor) {
        long start = System.currentTimeMillis();
        Validate.argumentsAreNotNull(author, commitProperties, currentVersion);
        this.assertJaversTypeNotValueTypeOrPrimitiveType(currentVersion);
        CompletionStage commit = ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.commitFactory.create(author, commitProperties, currentVersion), executor).thenApply(it -> new CommitWithTimestamp((Commit)it, System.currentTimeMillis()))).thenApplyAsync(it -> {
            this.persist(it.getCommit());
            return it;
        }, executor)).thenApply(it -> this.logCommitMessage(start, (CommitWithTimestamp)it));
        return commit;
    }

    private Commit logCommitMessage(long start, CommitWithTimestamp it) {
        long stop = System.currentTimeMillis();
        Commit persistedCommit = it.getCommit();
        Long creationTime = it.getTimestamp();
        logger.info(persistedCommit.toString() + ", done asynchronously in " + (stop - start) + " millis (diff:{}, persist:{})", (Object)(creationTime - start), (Object)(stop - creationTime));
        return persistedCommit;
    }

    @Override
    public Commit commitShallowDelete(String author, Object deleted) {
        return this.commitShallowDelete(author, deleted, Collections.emptyMap());
    }

    @Override
    public Commit commitShallowDelete(String author, Object deleted, Map<String, String> properties) {
        Validate.argumentsAreNotNull(author, properties, deleted);
        Commit commit = this.commitFactory.createTerminal(author, properties, deleted);
        this.repository.persist(commit);
        logger.info(commit.toString());
        return commit;
    }

    @Override
    public Commit commitShallowDeleteById(String author, GlobalIdDTO globalId) {
        return this.commitShallowDeleteById(author, globalId, Collections.emptyMap());
    }

    @Override
    public Commit commitShallowDeleteById(String author, GlobalIdDTO globalId, Map<String, String> properties) {
        Validate.argumentsAreNotNull(author, properties, globalId);
        Commit commit = this.commitFactory.createTerminalByGlobalId(author, properties, this.globalIdFactory.createFromDto(globalId));
        this.repository.persist(commit);
        logger.info(commit.toString());
        return commit;
    }

    @Override
    public Diff compare(Object oldVersion, Object currentVersion) {
        return this.diffFactory.compare(oldVersion, currentVersion);
    }

    @Override
    public Diff initial(Object newDomainObject) {
        Validate.argumentIsNotNull(newDomainObject);
        return this.diffFactory.initial(newDomainObject);
    }

    @Override
    public <T> List<Shadow<T>> findShadows(JqlQuery query) {
        Validate.argumentIsNotNull(query);
        return this.findShadowsAndStream(query).collect(Collectors.toList());
    }

    @Override
    public <T> Stream<Shadow<T>> findShadowsAndStream(JqlQuery query) {
        Validate.argumentIsNotNull(query);
        return this.queryRunner.queryForShadowsStream(query);
    }

    @Override
    public List<CdoSnapshot> findSnapshots(JqlQuery query) {
        Validate.argumentIsNotNull(query);
        return this.queryRunner.queryForSnapshots(query);
    }

    @Override
    public Changes findChanges(JqlQuery query) {
        Validate.argumentIsNotNull(query);
        return new Changes(this.queryRunner.queryForChanges(query), this.configuration.getPrettyValuePrinter());
    }

    @Override
    public Optional<CdoSnapshot> getLatestSnapshot(Object localId, Class entity) {
        Validate.argumentsAreNotNull(localId, entity);
        return this.queryRunner.runQueryForLatestSnapshot(InstanceIdDTO.instanceId(localId, entity));
    }

    @Override
    public Optional<CdoSnapshot> getHistoricalSnapshot(Object localId, Class entity, LocalDateTime effectiveDate) {
        Validate.argumentsAreNotNull(localId, entity, effectiveDate);
        return this.repository.getHistorical(this.globalIdFactory.createInstanceId(localId, entity), effectiveDate);
    }

    @Override
    public JsonConverter getJsonConverter() {
        return this.jsonConverter;
    }

    @Override
    public <T> T processChangeList(List<Change> changes, ChangeProcessor<T> changeProcessor) {
        Validate.argumentsAreNotNull(changes, changeProcessor);
        ChangeListTraverser.traverse(changes, changeProcessor);
        return changeProcessor.result();
    }

    @Override
    public <T extends JaversType> T getTypeMapping(Type clientsType) {
        return (T)this.typeMapper.getJaversType(clientsType);
    }

    public <T extends ManagedType> T getTypeMapping(String typeName) {
        return (T)this.typeMapper.getJaversManagedType(typeName, ManagedType.class);
    }

    @Override
    public <T> Diff compareCollections(Collection<T> oldVersion, Collection<T> currentVersion, Class<T> itemClass) {
        return this.diffFactory.compareCollections(oldVersion, currentVersion, itemClass);
    }

    @Override
    public Property getProperty(PropertyChange propertyChange) {
        ManagedType managedType = this.typeMapper.getJaversManagedType(propertyChange.getAffectedGlobalId());
        return managedType.getProperty(propertyChange.getPropertyName());
    }

    @Override
    public CoreConfiguration getCoreConfiguration() {
        return this.configuration;
    }

    private static class CommitWithTimestamp {
        private Commit commit;
        private Long timestamp;

        CommitWithTimestamp(Commit commit, Long timestamp) {
            this.commit = commit;
            this.timestamp = timestamp;
        }

        Commit getCommit() {
            return this.commit;
        }

        Long getTimestamp() {
            return this.timestamp;
        }
    }
}

