/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.custom;

import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.custom.CustomPropertyComparator;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;

public class CustomToNativeAppenderAdapter<T, C extends PropertyChange>
implements PropertyChangeAppender<C> {
    private final CustomPropertyComparator<T, C> delegate;
    private final Class<T> propertyJavaClass;

    public CustomToNativeAppenderAdapter(CustomPropertyComparator<T, C> delegate, Class<T> propertyJavaClass) {
        this.delegate = delegate;
        this.propertyJavaClass = propertyJavaClass;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType.getBaseJavaType().equals(this.propertyJavaClass);
    }

    @Override
    public C calculateChanges(NodePair pair, JaversProperty property) {
        Object leftValue = pair.getLeftPropertyValue(property);
        Object rightValue = pair.getRightPropertyValue(property);
        return (C)((PropertyChange)this.delegate.compare(leftValue, rightValue, pair.createPropertyChangeMetadata(property), property).orElse(null));
    }

    @Override
    public int priority() {
        return 1;
    }
}

