/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.javers.common.collections.Lists;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.common.validation.Validate;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.PropertyChangeMetadata;
import org.javers.core.diff.changetype.map.EntryAdded;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.diff.changetype.map.EntryRemoved;
import org.javers.core.diff.changetype.map.EntryValueChange;

public abstract class KeyValueChange<T>
extends PropertyChange<T> {
    private final List<EntryChange> changes;
    private final transient T left;
    private final transient T right;

    public KeyValueChange(PropertyChangeMetadata metadata, List<EntryChange> changes, T left, T right) {
        super(metadata);
        Validate.argumentIsNotNull(changes);
        Validate.argumentCheck(!changes.isEmpty(), "changes list should not be empty");
        this.changes = Collections.unmodifiableList(new ArrayList<EntryChange>(changes));
        this.left = left;
        this.right = right;
    }

    @Override
    public T getRight() {
        return this.right;
    }

    @Override
    public T getLeft() {
        return this.left;
    }

    public List<EntryChange> getEntryChanges() {
        return this.changes;
    }

    public List<EntryAdded> getEntryAddedChanges() {
        return this.filterChanges(EntryAdded.class);
    }

    public List<EntryRemoved> getEntryRemovedChanges() {
        return this.filterChanges(EntryRemoved.class);
    }

    public List<EntryValueChange> getEntryValueChanges() {
        return this.filterChanges(EntryValueChange.class);
    }

    private <T extends EntryChange> List<T> filterChanges(Class<T> ofType) {
        return Lists.positiveFilter(this.changes, input -> ofType.isAssignableFrom(input.getClass()));
    }

    @Override
    public String prettyPrint(PrettyValuePrinter valuePrinter) {
        Validate.argumentIsNotNull(valuePrinter);
        StringBuilder builder = new StringBuilder();
        builder.append(valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " map changes :\n");
        this.changes.forEach(cc -> builder.append("   " + cc.prettyPrint(valuePrinter) + "\n"));
        String result = builder.toString();
        return result.substring(0, result.length() - 1);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof KeyValueChange) {
            KeyValueChange that = (KeyValueChange)obj;
            return super.equals(that) && Objects.equals(this.changes, that.changes);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.changes);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{ property: '" + this.getPropertyName() + "', entryChanges:" + this.changes.size() + " }";
    }
}

