/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Optional;
import org.javers.core.IgnoredClassesStrategy;
import org.javers.core.metamodel.type.IgnoredType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.TypeMapper;
import org.slf4j.Logger;

public class DynamicMappingStrategy {
    private static final Logger logger = TypeMapper.logger;
    private final IgnoredClassesStrategy ignoredClassesStrategy;

    public DynamicMappingStrategy(IgnoredClassesStrategy ignoredClassesStrategy) {
        this.ignoredClassesStrategy = ignoredClassesStrategy;
    }

    public DynamicMappingStrategy() {
        this.ignoredClassesStrategy = null;
    }

    Optional<JaversType> map(Type type) {
        if (this.ignoredClassesStrategy != null && type instanceof Class) {
            Class clazz = (Class)type;
            if (this.ignoredClassesStrategy.isIgnored(clazz)) {
                logger.debug("javersType of '{}' mapped as IgnoredType by {}", (Object)clazz.getSimpleName(), (Object)this.ignoredClassesStrategy.getClass().getName());
                return Optional.of(new IgnoredType(clazz));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

