/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import org.jberet.job.model.Job;
import org.jberet.repository.ApplicationAndJobName;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.util.BatchLogger;
import org.jberet.util.BatchUtil;

public abstract class AbstractRepository
implements JobRepository {
    final ConcurrentMap<String, Job> jobs = new ConcurrentHashMap<String, Job>();
    final Map<Long, JobInstance> jobInstances = Collections.synchronizedMap(new LinkedHashMap());
    final ConcurrentMap<Long, JobExecution> jobExecutions = new ConcurrentHashMap<Long, JobExecution>();

    abstract void insertJobInstance(JobInstanceImpl var1);

    abstract void insertJobExecution(JobExecutionImpl var1);

    abstract void insertStepExecution(StepExecutionImpl var1, JobExecutionImpl var2);

    @Override
    public void addJob(Job job) {
        Job existing = this.jobs.putIfAbsent(job.getId(), job);
        if (existing != null) {
            BatchLogger.LOGGER.jobAlreadyExists(job.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJob(String jobId) {
        this.jobs.remove(jobId);
        Map<Long, JobInstance> map = this.jobInstances;
        synchronized (map) {
            Iterator<Map.Entry<Long, JobInstance>> it = this.jobInstances.entrySet().iterator();
            while (it.hasNext()) {
                JobInstance ji = it.next().getValue();
                if (!ji.getJobName().equals(jobId)) continue;
                it.remove();
            }
        }
        Iterator it = this.jobExecutions.entrySet().iterator();
        while (it.hasNext()) {
            JobExecution je = (JobExecution)it.next().getValue();
            if (!je.getJobName().equals(jobId)) continue;
            it.remove();
        }
    }

    @Override
    public Job getJob(String jobId) {
        return (Job)this.jobs.get(jobId);
    }

    @Override
    public Collection<Job> getJobs() {
        return this.jobs.values();
    }

    @Override
    public JobInstanceImpl createJobInstance(Job job, String applicationName, ClassLoader classLoader) {
        ApplicationAndJobName appJobNames = new ApplicationAndJobName(applicationName, job.getId());
        JobInstanceImpl jobInstance = new JobInstanceImpl(job, appJobNames);
        this.insertJobInstance(jobInstance);
        JobInstance jobInstanceExisting = this.jobInstances.put(jobInstance.getInstanceId(), jobInstance);
        if (jobInstanceExisting != null) {
            throw BatchLogger.LOGGER.jobInstanceAlreadyExists(jobInstance.getInstanceId());
        }
        return jobInstance;
    }

    @Override
    public void removeJobInstance(long jobInstanceIdToRemove) {
        this.jobInstances.remove(jobInstanceIdToRemove);
    }

    @Override
    public JobInstance getJobInstance(long jobInstanceId) {
        return this.jobInstances.get(jobInstanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobInstance> getJobInstances() {
        ArrayList<JobInstance> result = new ArrayList<JobInstance>();
        Map<Long, JobInstance> map = this.jobInstances;
        synchronized (map) {
            for (JobInstance e : this.jobInstances.values()) {
                result.add(e);
            }
        }
        return result;
    }

    @Override
    public JobExecutionImpl createJobExecution(JobInstanceImpl jobInstance, Properties jobParameters) {
        JobExecutionImpl jobExecution = new JobExecutionImpl(jobInstance, jobParameters);
        this.insertJobExecution(jobExecution);
        JobExecution jobExecutionExisting = this.jobExecutions.putIfAbsent(jobExecution.getExecutionId(), jobExecution);
        if (jobExecutionExisting != null) {
            throw BatchLogger.LOGGER.jobExecutionAlreadyExists(jobExecutionExisting.getExecutionId());
        }
        jobInstance.addJobExecution(jobExecution);
        return jobExecution;
    }

    @Override
    public JobExecution getJobExecution(long jobExecutionId) {
        return (JobExecution)this.jobExecutions.get(jobExecutionId);
    }

    @Override
    public Collection<JobExecution> getJobExecutions() {
        return this.jobExecutions.values();
    }

    @Override
    public StepExecutionImpl createStepExecution(String stepName) {
        return new StepExecutionImpl(stepName);
    }

    @Override
    public void addStepExecution(JobExecutionImpl jobExecution, StepExecutionImpl stepExecution) {
        jobExecution.addStepExecution(stepExecution);
        this.insertStepExecution(stepExecution, jobExecution);
    }

    @Override
    public void savePersistentData(JobExecution jobExecution, StepExecutionImpl stepExecution) {
        Serializable copy;
        Serializable ser = stepExecution.getPersistentUserData();
        if (ser != null) {
            copy = BatchUtil.clone(ser);
            stepExecution.setPersistentUserData(copy);
        }
        if ((ser = stepExecution.getReaderCheckpointInfo()) != null) {
            copy = BatchUtil.clone(ser);
            stepExecution.setReaderCheckpointInfo(copy);
        }
        if ((ser = stepExecution.getWriterCheckpointInfo()) != null) {
            copy = BatchUtil.clone(ser);
            stepExecution.setWriterCheckpointInfo(copy);
        }
    }
}

