/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import java.util.concurrent.atomic.AtomicLong;
import org.jberet.repository.AbstractRepository;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.spi.BatchEnvironment;

public final class InMemoryRepository
extends AbstractRepository {
    private final AtomicLong jobInstanceIdSequence = new AtomicLong();
    private final AtomicLong jobExecutionIdSequence = new AtomicLong();
    private final AtomicLong stepExecutionIdSequence = new AtomicLong();

    private InMemoryRepository() {
    }

    static InMemoryRepository getInstance(BatchEnvironment batchEnvironment) {
        return Holder.instance;
    }

    @Override
    void insertJobInstance(JobInstanceImpl jobInstance) {
        jobInstance.setId(this.jobInstanceIdSequence.incrementAndGet());
    }

    @Override
    void insertJobExecution(JobExecutionImpl jobExecution) {
        jobExecution.setId(this.jobExecutionIdSequence.incrementAndGet());
    }

    @Override
    void insertStepExecution(StepExecutionImpl stepExecution, JobExecutionImpl jobExecution) {
        stepExecution.setId(this.stepExecutionIdSequence.incrementAndGet());
    }

    private static class Holder {
        private static final InMemoryRepository instance = new InMemoryRepository();

        private Holder() {
        }
    }
}

