/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.util;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Properties;
import javax.batch.operations.JobStartException;
import org.jberet.job.model.Flow;
import org.jberet.job.model.Job;
import org.jberet.job.model.Step;
import org.jboss.marshalling.cloner.ClonerConfiguration;
import org.jboss.marshalling.cloner.ObjectCloner;
import org.jboss.marshalling.cloner.ObjectClonerFactory;
import org.jboss.marshalling.cloner.ObjectCloners;

public class BatchUtil {
    public static final String NL = BatchUtil.getSystemProperty("line.separator");
    private static final ObjectClonerFactory clonerFactory = ObjectCloners.getSerializingObjectClonerFactory();
    private static final ObjectCloner cloner = clonerFactory.createCloner(new ClonerConfiguration());

    public static String propertiesToString(Properties properties) {
        if (properties == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String key : properties.stringPropertyNames()) {
            sb.append(key).append('=').append(properties.getProperty(key)).append(NL);
        }
        return sb.toString();
    }

    public static StringBuilder toElementSequence(List<?> elements) {
        StringBuilder sb = new StringBuilder();
        for (Object e : elements) {
            if (e instanceof Step) {
                sb.append(((Step)e).getId());
            } else if (e instanceof Job) {
                sb.append(((Job)e).getId());
            } else if (e instanceof Flow) {
                sb.append(((Flow)e).getId());
            }
            sb.append(" -> ");
        }
        return sb;
    }

    public static <T> T clone(T original) throws JobStartException {
        try {
            cloner.reset();
            return (T)cloner.clone(original);
        }
        catch (IOException e) {
            throw new JobStartException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new JobStartException((Throwable)e);
        }
    }

    private static String getSystemProperty(final String key) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(key);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }
}

