/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.batch.operations.BatchRuntimeException;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;
import org.jberet.job.model.Chunk;
import org.jberet.job.model.Decision;
import org.jberet.job.model.ExceptionClassFilter;
import org.jberet.job.model.Flow;
import org.jberet.job.model.Job;
import org.jberet.job.model.Partition;
import org.jberet.job.model.PartitionPlan;
import org.jberet.job.model.Properties;
import org.jberet.job.model.RefArtifact;
import org.jberet.job.model.Split;
import org.jberet.job.model.Step;
import org.jberet.job.model.Transition;

public final class PropertyResolver {
    protected static final String jobParametersToken = "jobParameters";
    protected static final String jobPropertiesToken = "jobProperties";
    protected static final String systemPropertiesToken = "systemProperties";
    protected static final String partitionPlanToken = "partitionPlan";
    private static final String prefix = "#{";
    private static final String defaultValuePrefix = "?:";
    private static final int shortestTemplateLen = "#{jobProperties['x']}".length();
    private static final int prefixLen = "#{".length();
    private java.util.Properties systemProperties = PropertyResolver.getSystemProperties();
    private java.util.Properties jobParameters;
    private java.util.Properties partitionPlanProperties;
    private Deque<Properties> jobPropertiesStack = new ArrayDeque<Properties>();
    private boolean resolvePartitionPlanProperties;

    public void setSystemProperties(java.util.Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public void setJobParameters(java.util.Properties jobParameters) {
        this.jobParameters = jobParameters;
    }

    public void setPartitionPlanProperties(java.util.Properties partitionPlanProperties) {
        this.partitionPlanProperties = partitionPlanProperties;
    }

    public void pushJobProperties(Properties jobProps) {
        this.jobPropertiesStack.push(jobProps);
    }

    public void setResolvePartitionPlanProperties(boolean resolvePartitionPlanProperties) {
        this.resolvePartitionPlanProperties = resolvePartitionPlanProperties;
    }

    public void resolve(Job job) {
        String newVal;
        String oldVal = job.getRestartable();
        if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            job.setRestartable(newVal);
        }
        Properties props = job.getProperties();
        this.resolve(props, false);
        this.resolve(job.getListeners());
        this.resolveJobElements(job.getJobElements());
        if (props != null) {
            this.jobPropertiesStack.pop();
        }
    }

    private void resolveJobElements(List<?> jobElements) {
        if (jobElements == null) {
            return;
        }
        for (Object e : jobElements) {
            if (e instanceof Step) {
                this.resolve((Step)e);
                continue;
            }
            if (e instanceof Flow) {
                this.resolve((Flow)e);
                continue;
            }
            if (e instanceof Decision) {
                this.resolve((Decision)e);
                continue;
            }
            if (!(e instanceof Split)) continue;
            this.resolve((Split)e);
        }
    }

    public void resolve(Step step) {
        String newVal;
        this.resolve(step.getPartition());
        String oldVal = step.getAttributeNext();
        if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            step.setAttributeNext(newVal);
        }
        if ((oldVal = step.getAllowStartIfComplete()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            step.setAllowStartIfComplete(newVal);
        }
        if ((oldVal = step.getStartLimit()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            step.setStartLimit(newVal);
        }
        Properties props = step.getProperties();
        this.resolve(props, false);
        this.resolve(step.getListeners());
        RefArtifact batchlet = step.getBatchlet();
        if (batchlet != null) {
            oldVal = batchlet.getRef();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                batchlet.setRef(newVal);
            }
            this.resolve(batchlet.getProperties(), true);
        }
        this.resolve(step.getChunk());
        this.resolveTransitionElements(step.getTransitionElements());
        if (props != null) {
            this.jobPropertiesStack.pop();
        }
    }

    private void resolve(Partition partition) {
        RefArtifact mapper;
        PartitionPlan plan;
        RefArtifact reducer;
        RefArtifact collector;
        String newVal;
        String oldVal;
        if (partition == null) {
            return;
        }
        RefArtifact analyzer = partition.getAnalyzer();
        if (analyzer != null) {
            oldVal = analyzer.getRef();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                analyzer.setRef(newVal);
            }
            this.resolve(analyzer.getProperties(), true);
        }
        if ((collector = partition.getCollector()) != null) {
            oldVal = collector.getRef();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                collector.setRef(newVal);
            }
            this.resolve(collector.getProperties(), true);
        }
        if ((reducer = partition.getReducer()) != null) {
            oldVal = reducer.getRef();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                reducer.setRef(newVal);
            }
            this.resolve(reducer.getProperties(), true);
        }
        if ((plan = partition.getPlan()) != null) {
            oldVal = plan.getPartitions();
            if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
                plan.setPartitions(newVal);
            }
            if ((oldVal = plan.getThreads()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
                plan.setThreads(newVal);
            }
            if (!this.resolvePartitionPlanProperties) {
                for (Properties p : plan.getPropertiesList()) {
                    this.resolve(p, true);
                }
            }
        }
        if ((mapper = partition.getMapper()) != null) {
            oldVal = mapper.getRef();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                mapper.setRef(newVal);
            }
            if (!this.resolvePartitionPlanProperties) {
                this.resolve(mapper.getProperties(), true);
            }
        }
    }

    private void resolve(Chunk chunk) {
        RefArtifact checkpointAlgorithm;
        RefArtifact reader;
        String newVal;
        if (chunk == null) {
            return;
        }
        this.resolve(chunk.getSkippableExceptionClasses());
        this.resolve(chunk.getRetryableExceptionClasses());
        this.resolve(chunk.getNoRollbackExceptionClasses());
        String oldVal = chunk.getCheckpointPolicy();
        if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            chunk.setCheckpointPolicy(newVal);
        }
        if ((oldVal = chunk.getItemCount()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            chunk.setItemCount(newVal);
        }
        if ((oldVal = chunk.getTimeLimit()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            chunk.setTimeLimit(newVal);
        }
        if ((oldVal = chunk.getSkipLimit()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            chunk.setSkipLimit(newVal);
        }
        if ((oldVal = chunk.getRetryLimit()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            chunk.setRetryLimit(newVal);
        }
        if (!(oldVal = (reader = chunk.getReader()).getRef()).equals(newVal = this.resolve(oldVal))) {
            reader.setRef(newVal);
        }
        this.resolve(reader.getProperties(), true);
        RefArtifact writer = chunk.getWriter();
        oldVal = writer.getRef();
        newVal = this.resolve(oldVal);
        if (!oldVal.equals(newVal)) {
            writer.setRef(newVal);
        }
        this.resolve(writer.getProperties(), true);
        RefArtifact processor = chunk.getProcessor();
        if (processor != null) {
            oldVal = processor.getRef();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                processor.setRef(newVal);
            }
            this.resolve(processor.getProperties(), true);
        }
        if ((checkpointAlgorithm = chunk.getCheckpointAlgorithm()) != null) {
            oldVal = checkpointAlgorithm.getRef();
            if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
                checkpointAlgorithm.setRef(newVal);
            }
            this.resolve(checkpointAlgorithm.getProperties(), true);
        }
    }

    private void resolve(ExceptionClassFilter filter) {
        if (filter == null) {
            return;
        }
        this.resolveIncludeOrExclude(filter.include);
        this.resolveIncludeOrExclude(filter.exclude);
    }

    private void resolveIncludeOrExclude(List<String> clude) {
        ListIterator<String> it = clude.listIterator();
        while (it.hasNext()) {
            String newVal;
            String oldVal = it.next();
            if (oldVal.equals(newVal = this.resolve(oldVal))) continue;
            it.set(newVal);
        }
    }

    private void resolve(Split split) {
        String newVal;
        String oldVal = split.getAttributeNext();
        if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            split.setAttributeNext(newVal);
        }
        for (Flow e : split.getFlows()) {
            this.resolve(e);
        }
    }

    public void resolve(Flow flow) {
        String newVal;
        String oldVal = flow.getAttributeNext();
        if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            flow.setAttributeNext(newVal);
        }
        this.resolveTransitionElements(flow.getTransitionElements());
        this.resolveJobElements(flow.getJobElements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve(Properties props, boolean popProps) {
        if (props == null) {
            return;
        }
        Properties propsToPush = new Properties();
        this.jobPropertiesStack.push(propsToPush);
        try {
            String newPartitionVal;
            String oldPartitionVal = props.getPartition();
            if (oldPartitionVal != null && !oldPartitionVal.equals(newPartitionVal = this.resolve(oldPartitionVal))) {
                props.setPartition(newPartitionVal);
            }
            Map<String, String> propertiesMapping = props.getPropertiesMapping();
            for (Map.Entry<String, String> entry : propertiesMapping.entrySet()) {
                String oldKey = entry.getKey();
                String newKey = this.resolve(oldKey);
                String oldVal = entry.getValue();
                String newVal = this.resolve(oldVal);
                if (oldKey.equals(newKey)) {
                    if (!oldVal.equals(newVal)) {
                        props.add(newKey, newVal);
                    }
                } else {
                    props.remove(oldKey);
                    props.add(newKey, newVal);
                }
                propsToPush.add(newKey, newVal);
            }
        }
        finally {
            if (popProps) {
                this.jobPropertiesStack.pop();
            }
        }
    }

    private void resolve(List<RefArtifact> listeners) {
        if (listeners == null) {
            return;
        }
        for (RefArtifact l : listeners) {
            String newVal;
            String oldVal = l.getRef();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                l.setRef(newVal);
            }
            this.resolve(l.getProperties(), true);
        }
    }

    private void resolve(Decision decision) {
        String newVal;
        String oldVal = decision.getRef();
        if (!oldVal.equals(newVal = this.resolve(oldVal))) {
            decision.setRef(newVal);
        }
        this.resolve(decision.getProperties(), true);
        this.resolveTransitionElements(decision.getTransitionElements());
    }

    private void resolveTransitionElements(List<?> transitions) {
        for (Object e : transitions) {
            String newVal;
            String oldVal;
            if (e instanceof Transition.Next) {
                Transition.Next next = (Transition.Next)e;
                oldVal = next.getTo();
                if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                    next.setTo(newVal);
                }
                if ((oldVal = next.getOn()).equals(newVal = this.resolve(oldVal))) continue;
                next.setOn(newVal);
                continue;
            }
            if (e instanceof Transition.Fail) {
                Transition.Fail fail = (Transition.Fail)e;
                oldVal = fail.getOn();
                if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                    fail.setOn(newVal);
                }
                if ((oldVal = fail.getExitStatus()) == null || oldVal.equals(newVal = this.resolve(oldVal))) continue;
                fail.setExitStatus(newVal);
                continue;
            }
            if (e instanceof Transition.End) {
                Transition.End end = (Transition.End)e;
                oldVal = end.getOn();
                if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                    end.setOn(newVal);
                }
                if ((oldVal = end.getExitStatus()) == null || oldVal.equals(newVal = this.resolve(oldVal))) continue;
                end.setExitStatus(newVal);
                continue;
            }
            if (!(e instanceof Transition.Stop)) continue;
            Transition.Stop stop = (Transition.Stop)e;
            oldVal = stop.getOn();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                stop.setOn(newVal);
            }
            if ((oldVal = stop.getExitStatus()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
                stop.setExitStatus(newVal);
            }
            if ((oldVal = stop.getRestart()) == null || oldVal.equals(newVal = this.resolve(oldVal))) continue;
            stop.setRestart(newVal);
        }
    }

    public String resolve(String rawVale) {
        if (rawVale.length() < shortestTemplateLen || !rawVale.contains(prefix)) {
            return rawVale;
        }
        StringBuilder sb = new StringBuilder(rawVale);
        try {
            this.resolve(sb, 0, true, null);
        }
        catch (BatchRuntimeException e) {
            BatchLogger.LOGGER.unresolvableExpression(e.getMessage());
            return null;
        }
        return sb.toString();
    }

    private void resolve(StringBuilder sb, int start, boolean defaultAllowed, LinkedList<String> referringExpressions) throws BatchRuntimeException {
        if (sb.length() - start < shortestTemplateLen) {
            return;
        }
        int startExpression = sb.indexOf(prefix, start);
        if (startExpression < 0) {
            return;
        }
        int startPropCategory = startExpression + prefixLen;
        int openBracket = sb.indexOf("[", startPropCategory);
        String propCategory = sb.substring(startPropCategory, openBracket);
        int startVariableName = openBracket + 2;
        int endBracket = sb.indexOf("]", startVariableName + 1);
        int endExpression = endBracket + 1;
        if (endExpression >= sb.length()) {
            BatchLogger.LOGGER.possibleSyntaxErrorInProperty(sb.toString());
            endExpression = sb.length() - 1;
        }
        int endCurrentPass = endExpression;
        String expression = sb.substring(startExpression, endExpression + 1);
        if (referringExpressions != null && referringExpressions.contains(expression)) {
            throw BatchMessages.MESSAGES.cycleInPropertyReference(referringExpressions);
        }
        if (!this.resolvePartitionPlanProperties && propCategory.equals(partitionPlanToken)) {
            this.resolve(sb, endCurrentPass + 1, true, null);
            return;
        }
        String variableName = sb.substring(startVariableName, endBracket - 1);
        String val = this.getPropertyValue(variableName, propCategory, sb);
        if (val != null) {
            val = this.reresolve(expression, val, defaultAllowed, referringExpressions);
        }
        if (!defaultAllowed) {
            if (val == null) {
                val = "";
            }
            endCurrentPass = this.replaceAndGetEndPosition(sb, startExpression, endExpression, val);
        } else {
            int startDefaultMarker = endExpression + 1;
            int endDefaultMarker = startDefaultMarker + 1;
            String next2Chars = null;
            if (endDefaultMarker < sb.length()) {
                next2Chars = sb.substring(startDefaultMarker, endDefaultMarker + 1);
            }
            boolean hasDefault = defaultValuePrefix.equals(next2Chars);
            int endDefaultExpressionMarker = sb.indexOf(";", endDefaultMarker + 1);
            if (endDefaultExpressionMarker < 0) {
                endDefaultExpressionMarker = sb.length();
            }
            if (val != null) {
                endCurrentPass = !hasDefault ? this.replaceAndGetEndPosition(sb, startExpression, endExpression, val) : this.replaceAndGetEndPosition(sb, startExpression, endDefaultExpressionMarker, val);
            } else if (!hasDefault) {
                endCurrentPass = this.replaceAndGetEndPosition(sb, startExpression, endExpression, "");
            } else {
                StringBuilder sb4DefaultExpression = new StringBuilder(sb.substring(endDefaultMarker + 1, endDefaultExpressionMarker));
                this.resolve(sb4DefaultExpression, 0, false, null);
                endCurrentPass = this.replaceAndGetEndPosition(sb, startExpression, endDefaultExpressionMarker, sb4DefaultExpression.toString());
            }
        }
        this.resolve(sb, endCurrentPass + 1, true, null);
    }

    private String reresolve(String expression, String currentlyResolvedToVal, boolean defaultAllowed, LinkedList<String> referringExpressions) throws BatchRuntimeException {
        if (currentlyResolvedToVal.length() < shortestTemplateLen || !currentlyResolvedToVal.contains(prefix)) {
            return currentlyResolvedToVal;
        }
        if (referringExpressions == null) {
            referringExpressions = new LinkedList();
        }
        referringExpressions.add(expression);
        StringBuilder sb = new StringBuilder(currentlyResolvedToVal);
        try {
            this.resolve(sb, 0, defaultAllowed, referringExpressions);
        }
        catch (BatchRuntimeException e) {
            BatchLogger.LOGGER.unresolvableExpression(e.getMessage());
            return null;
        }
        return sb.toString();
    }

    private int replaceAndGetEndPosition(StringBuilder sb, int startExpression, int endExpression, String replacingVal) {
        sb.replace(startExpression, endExpression + 1, replacingVal);
        return startExpression - 1 + replacingVal.length();
    }

    private String getPropertyValue(String variableName, String propCategory, StringBuilder sb) {
        String val = null;
        if (propCategory.equals(jobParametersToken)) {
            if (this.jobParameters != null) {
                val = this.jobParameters.getProperty(variableName);
            }
        } else if (propCategory.equals(jobPropertiesToken)) {
            Properties p;
            Iterator<Properties> i$ = this.jobPropertiesStack.iterator();
            while (i$.hasNext() && (val = (p = i$.next()).get(variableName)) == null) {
            }
        } else if (propCategory.equals(systemPropertiesToken)) {
            val = this.systemProperties.getProperty(variableName);
        } else if (propCategory.equals(partitionPlanToken)) {
            if (this.partitionPlanProperties != null) {
                val = this.partitionPlanProperties.getProperty(variableName);
            }
        } else {
            BatchLogger.LOGGER.unrecognizedPropertyReference(propCategory, variableName, sb.toString());
        }
        return val;
    }

    private static java.util.Properties getSystemProperties() {
        if (System.getSecurityManager() == null) {
            return System.getProperties();
        }
        return AccessController.doPrivileged(new PrivilegedAction<java.util.Properties>(){

            @Override
            public java.util.Properties run() {
                return System.getProperties();
            }
        });
    }
}

