/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import javax.batch.api.Batchlet;
import javax.batch.api.partition.PartitionCollector;
import javax.batch.runtime.BatchStatus;
import org.jberet._private.BatchLogger;
import org.jberet.job.model.RefArtifact;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.runner.AbstractRunner;
import org.jberet.runtime.runner.CompositeExecutionRunner;
import org.jberet.runtime.runner.StepExecutionRunner;

public final class BatchletRunner
extends AbstractRunner<StepContextImpl>
implements Runnable {
    private final RefArtifact batchlet;
    private final StepExecutionRunner stepRunner;
    private PartitionCollector collector;
    private Batchlet batchletObj;

    public BatchletRunner(StepContextImpl stepContext, CompositeExecutionRunner enclosingRunner, StepExecutionRunner stepRunner, RefArtifact batchlet) {
        super(stepContext, enclosingRunner);
        this.stepRunner = stepRunner;
        this.batchlet = batchlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block25: {
            block24: {
                RefArtifact collectorConfig;
                if (this.stepRunner.collectorDataQueue != null && (collectorConfig = ((StepContextImpl)this.batchContext).getStep().getPartition().getCollector()) != null) {
                    this.collector = (PartitionCollector)this.jobContext.createArtifact(collectorConfig.getRef(), null, collectorConfig.getProperties(), (StepContextImpl)this.batchContext);
                }
                this.batchletObj = (Batchlet)this.jobContext.createArtifact(this.batchlet.getRef(), null, this.batchlet.getProperties(), (StepContextImpl)this.batchContext);
                this.jobContext.getBatchEnvironment().submitTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BatchletRunner.this.jobContext.getJobExecution().awaitStop();
                            if (((StepContextImpl)BatchletRunner.this.batchContext).getBatchStatus() == BatchStatus.STARTED) {
                                ((StepContextImpl)BatchletRunner.this.batchContext).setBatchStatus(BatchStatus.STOPPING);
                                BatchletRunner.this.batchletObj.stop();
                            }
                        }
                        catch (Exception e) {
                            BatchLogger.LOGGER.failToStopJob(e, BatchletRunner.this.jobContext.getJobName(), ((StepContextImpl)BatchletRunner.this.batchContext).getStepName(), BatchletRunner.this.batchletObj);
                        }
                    }
                });
                String exitStatus = this.batchletObj.process();
                switch (((StepContextImpl)this.batchContext).getBatchStatus()) {
                    case STARTED: {
                        ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.COMPLETED);
                        break;
                    }
                    case STOPPING: {
                        ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPED);
                    }
                }
                ((StepContextImpl)this.batchContext).setExitStatus(exitStatus);
                if (this.collector == null) break block24;
                this.stepRunner.collectorDataQueue.put(this.collector.collectPartitionData());
            }
            try {
                if (this.stepRunner.collectorDataQueue != null) {
                    this.stepRunner.collectorDataQueue.put(((StepContextImpl)this.batchContext).getStepExecution());
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.stepRunner.completedPartitionThreads != null) {
                this.stepRunner.completedPartitionThreads.offer(Boolean.TRUE);
            }
            this.jobContext.destroyArtifact(this.batchletObj, this.collector);
            break block25;
            catch (Exception e) {
                try {
                    try {
                        if (this.collector != null) {
                            this.stepRunner.collectorDataQueue.put(this.collector.collectPartitionData());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ((StepContextImpl)this.batchContext).setException(e);
                    BatchLogger.LOGGER.failToRunBatchlet(e, this.batchlet);
                    ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                }
                catch (Throwable throwable) {
                    try {
                        if (this.stepRunner.collectorDataQueue != null) {
                            this.stepRunner.collectorDataQueue.put(((StepContextImpl)this.batchContext).getStepExecution());
                        }
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    if (this.stepRunner.completedPartitionThreads != null) {
                        this.stepRunner.completedPartitionThreads.offer(Boolean.TRUE);
                    }
                    this.jobContext.destroyArtifact(this.batchletObj, this.collector);
                    throw throwable;
                }
                try {
                    if (this.stepRunner.collectorDataQueue != null) {
                        this.stepRunner.collectorDataQueue.put(((StepContextImpl)this.batchContext).getStepExecution());
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.stepRunner.completedPartitionThreads != null) {
                    this.stepRunner.completedPartitionThreads.offer(Boolean.TRUE);
                }
                this.jobContext.destroyArtifact(this.batchletObj, this.collector);
            }
        }
    }
}

