/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import jakarta.batch.api.chunk.CheckpointAlgorithm;
import jakarta.batch.api.chunk.ItemProcessor;
import jakarta.batch.api.chunk.ItemReader;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.batch.api.chunk.listener.ChunkListener;
import jakarta.batch.api.chunk.listener.ItemProcessListener;
import jakarta.batch.api.chunk.listener.ItemReadListener;
import jakarta.batch.api.chunk.listener.ItemWriteListener;
import jakarta.batch.api.chunk.listener.RetryProcessListener;
import jakarta.batch.api.chunk.listener.RetryReadListener;
import jakarta.batch.api.chunk.listener.RetryWriteListener;
import jakarta.batch.api.chunk.listener.SkipProcessListener;
import jakarta.batch.api.chunk.listener.SkipReadListener;
import jakarta.batch.api.chunk.listener.SkipWriteListener;
import jakarta.batch.api.partition.PartitionCollector;
import jakarta.batch.operations.BatchRuntimeException;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.Metric;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;
import org.jberet.creation.JobScopedContextImpl;
import org.jberet.job.model.Chunk;
import org.jberet.job.model.ExceptionClassFilter;
import org.jberet.job.model.Listeners;
import org.jberet.job.model.Properties;
import org.jberet.job.model.RefArtifact;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.metric.StepMetrics;
import org.jberet.runtime.runner.AbstractRunner;
import org.jberet.runtime.runner.CompositeExecutionRunner;
import org.jberet.runtime.runner.ScriptItemProcessor;
import org.jberet.runtime.runner.ScriptItemReader;
import org.jberet.runtime.runner.ScriptItemWriter;
import org.jberet.runtime.runner.StepExecutionRunner;
import org.jberet.spi.JobTask;
import org.jberet.spi.PartitionWorker;
import org.jboss.logging.Logger;

public final class ChunkRunner
extends AbstractRunner<StepContextImpl>
implements JobTask {
    private final List<Object> allChunkRelatedListeners = new ArrayList<Object>();
    private final List<ChunkListener> chunkListeners = new ArrayList<ChunkListener>();
    private final List<SkipWriteListener> skipWriteListeners = new ArrayList<SkipWriteListener>();
    private final List<SkipProcessListener> skipProcessListeners = new ArrayList<SkipProcessListener>();
    private final List<SkipReadListener> skipReadListeners = new ArrayList<SkipReadListener>();
    private final List<RetryReadListener> retryReadListeners = new ArrayList<RetryReadListener>();
    private final List<RetryWriteListener> retryWriteListeners = new ArrayList<RetryWriteListener>();
    private final List<RetryProcessListener> retryProcessListeners = new ArrayList<RetryProcessListener>();
    private final List<ItemReadListener> itemReadListeners = new ArrayList<ItemReadListener>();
    private final List<ItemWriteListener> itemWriteListeners = new ArrayList<ItemWriteListener>();
    private final List<ItemProcessListener> itemProcessListeners = new ArrayList<ItemProcessListener>();
    private final Chunk chunk;
    private final StepMetrics stepMetrics;
    private final AbstractStepExecution stepOrPartitionExecution;
    private ItemReader itemReader;
    private ItemWriter itemWriter;
    private ItemProcessor itemProcessor;
    private PartitionCollector collector;
    private String checkpointPolicy = "item";
    private CheckpointAlgorithm checkpointAlgorithm;
    private int itemCount = 10;
    private int timeLimit;
    private final int skipLimit;
    private final int retryLimit;
    private final ExceptionClassFilter skippableExceptionClasses;
    private final ExceptionClassFilter retryableExceptionClasses;
    private final ExceptionClassFilter noRollbackExceptionClasses;
    private int skipCount;
    private int retryCount;
    private Object itemRead;
    private final List<Object> outputList = new ArrayList<Object>();
    private final TransactionManager tm;
    private final AtomicBoolean itemReaderClosed = new AtomicBoolean(false);
    private final AtomicBoolean itemWriterClosed = new AtomicBoolean(false);
    private final PartitionWorker partitionWorker;

    public ChunkRunner(StepContextImpl stepContext, CompositeExecutionRunner enclosingRunner, Chunk chunk, TransactionManager tm, PartitionWorker partitionWorker) {
        super(stepContext, enclosingRunner);
        this.chunk = chunk;
        this.stepOrPartitionExecution = stepContext.getStepExecution();
        this.stepMetrics = this.stepOrPartitionExecution.getStepMetrics();
        this.partitionWorker = partitionWorker;
        String attrVal = chunk.getSkipLimit();
        this.skipLimit = attrVal == null ? -1 : Integer.parseInt(attrVal);
        attrVal = chunk.getRetryLimit();
        this.retryLimit = attrVal == null ? -1 : Integer.parseInt(attrVal);
        this.skippableExceptionClasses = chunk.getSkippableExceptionClasses();
        this.retryableExceptionClasses = chunk.getRetryableExceptionClasses();
        this.noRollbackExceptionClasses = chunk.getNoRollbackExceptionClasses();
        this.tm = tm != null ? tm : StepExecutionRunner.getTransactionManager(this.jobContext, stepContext.getStep());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block40: {
            String globalTimeoutProp;
            String attrVal;
            RefArtifact collectorConfig;
            this.itemReader = (ItemReader)this.createArtifact(this.chunk.getReader(), (StepContextImpl)this.batchContext, ScriptItemReader.class);
            this.itemWriter = (ItemWriter)this.createArtifact(this.chunk.getWriter(), (StepContextImpl)this.batchContext, ScriptItemWriter.class);
            RefArtifact processorElement = this.chunk.getProcessor();
            if (processorElement != null) {
                this.itemProcessor = (ItemProcessor)this.createArtifact(processorElement, (StepContextImpl)this.batchContext, ScriptItemProcessor.class);
            }
            if (this.partitionWorker != null && (collectorConfig = ((StepContextImpl)this.batchContext).getStep().getPartition().getCollector()) != null) {
                this.collector = (PartitionCollector)this.jobContext.createArtifact(collectorConfig.getRef(), null, collectorConfig.getProperties(), (StepContextImpl)this.batchContext);
            }
            if ((attrVal = this.chunk.getCheckpointPolicy()) == null || attrVal.equals("item")) {
                attrVal = this.chunk.getItemCount();
                if (attrVal != null) {
                    this.itemCount = Integer.parseInt(attrVal);
                    if (this.itemCount < 1) {
                        throw BatchMessages.MESSAGES.invalidItemCount(this.itemCount);
                    }
                }
                if ((attrVal = this.chunk.getTimeLimit()) != null) {
                    this.timeLimit = Integer.parseInt(attrVal);
                }
            } else {
                if (!attrVal.equals("custom")) throw BatchMessages.MESSAGES.invalidCheckpointPolicy(attrVal);
                this.checkpointPolicy = "custom";
                RefArtifact alg = this.chunk.getCheckpointAlgorithm();
                if (alg == null) throw BatchMessages.MESSAGES.checkpointAlgorithmMissing(((StepContextImpl)this.batchContext).getStep().getId());
                this.checkpointAlgorithm = (CheckpointAlgorithm)this.jobContext.createArtifact(alg.getRef(), null, alg.getProperties(), (StepContextImpl)this.batchContext);
            }
            this.createChunkRelatedListeners();
            Properties stepProps = ((StepContextImpl)this.batchContext).getStep().getProperties();
            int globalTimeout = 180;
            if (stepProps != null && (globalTimeoutProp = stepProps.get("jakarta.transaction.global.timeout")) != null) {
                globalTimeout = Integer.parseInt(globalTimeoutProp);
            }
            this.tm.setTransactionTimeout(globalTimeout);
            this.tm.begin();
            try {
                this.itemReaderClosed.set(false);
                this.itemReader.open(this.stepOrPartitionExecution.getReaderCheckpointInfo());
                this.itemWriterClosed.set(false);
                this.itemWriter.open(this.stepOrPartitionExecution.getWriterCheckpointInfo());
                this.tm.commit();
            }
            catch (Exception e) {
                this.tm.rollback();
                this.safeClose();
                throw e;
            }
            this.readProcessWriteItems();
            this.tm.begin();
            try {
                this.closeItemWriter();
                this.closeItemReader();
                this.tm.commit();
            }
            catch (Exception e) {
                this.tm.rollback();
                this.safeClose();
                throw e;
            }
            if (this.collector != null) {
                this.partitionWorker.reportData(this.collector.collectPartitionData(), this.stepOrPartitionExecution);
            }
            if (((StepContextImpl)this.batchContext).getBatchStatus() == BatchStatus.STARTED) {
                ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.COMPLETED);
            }
            if (this.partitionWorker == null) break block40;
            try {
                JobScopedContextImpl.ScopedInstance.destroy(((StepContextImpl)this.batchContext).getPartitionScopedBeans());
                this.partitionWorker.partitionDone(this.stepOrPartitionExecution);
            }
            catch (Exception e) {
                BatchLogger.LOGGER.problemFinalizingPartitionExecution(e, this.stepOrPartitionExecution.getStepExecutionId());
            }
        }
        this.jobContext.destroyArtifact(this.itemReader, this.itemWriter, this.itemProcessor, this.collector, this.checkpointAlgorithm);
        this.jobContext.destroyArtifact(this.allChunkRelatedListeners);
        try {
            this.tm.setTransactionTimeout(0);
            return;
        }
        catch (SystemException txSystemException) {
            BatchLogger.LOGGER.warn(this.toString(), txSystemException);
        }
        return;
        catch (Throwable e) {
            block41: {
                try {
                    ((StepContextImpl)this.batchContext).setException(e instanceof Exception ? (Exception)e : new BatchRuntimeException(e));
                    BatchLogger.LOGGER.log(Logger.Level.ERROR, "item-count=" + this.itemCount + ", time-limit=" + this.timeLimit + ", skip-limit=" + this.skipLimit + ", skipCount=" + this.skipCount + ", retry-limit=" + this.retryLimit + ", retryCount=" + this.retryCount);
                    BatchLogger.LOGGER.failToRunJob(e, this.jobContext.getJobName(), ((StepContextImpl)this.batchContext).getStepName(), this.chunk);
                    ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                    try {
                        this.closeItemWriter();
                    }
                    catch (Exception exception) {
                        BatchLogger.LOGGER.failToClose(exception, ItemWriter.class, this.itemWriter);
                    }
                    try {
                        this.closeItemReader();
                    }
                    catch (Exception exception) {
                        BatchLogger.LOGGER.failToClose(exception, ItemReader.class, this.itemReader);
                    }
                    try {
                        int txStatus = this.tm.getStatus();
                        if (txStatus == 0 || txStatus == 1 || txStatus == 2 || txStatus == 7 || txStatus == 8 || txStatus == 9) {
                            this.tm.rollback();
                            this.stepMetrics.increment(Metric.MetricType.ROLLBACK_COUNT, 1L);
                        } else if (txStatus == 4 || txStatus == 6) {
                            this.tm.suspend();
                            this.stepMetrics.increment(Metric.MetricType.ROLLBACK_COUNT, 1L);
                        }
                    }
                    catch (SystemException txSystemException) {
                        BatchLogger.LOGGER.warn(this.toString(), txSystemException);
                    }
                    if (this.partitionWorker == null) break block41;
                }
                catch (Throwable throwable) {
                    if (this.partitionWorker != null) {
                        try {
                            JobScopedContextImpl.ScopedInstance.destroy(((StepContextImpl)this.batchContext).getPartitionScopedBeans());
                            this.partitionWorker.partitionDone(this.stepOrPartitionExecution);
                        }
                        catch (Exception e2) {
                            BatchLogger.LOGGER.problemFinalizingPartitionExecution(e2, this.stepOrPartitionExecution.getStepExecutionId());
                        }
                    }
                    this.jobContext.destroyArtifact(this.itemReader, this.itemWriter, this.itemProcessor, this.collector, this.checkpointAlgorithm);
                    this.jobContext.destroyArtifact(this.allChunkRelatedListeners);
                    try {
                        this.tm.setTransactionTimeout(0);
                        throw throwable;
                    }
                    catch (SystemException txSystemException) {
                        BatchLogger.LOGGER.warn(this.toString(), txSystemException);
                    }
                    throw throwable;
                }
                try {
                    JobScopedContextImpl.ScopedInstance.destroy(((StepContextImpl)this.batchContext).getPartitionScopedBeans());
                    this.partitionWorker.partitionDone(this.stepOrPartitionExecution);
                }
                catch (Exception e3) {
                    BatchLogger.LOGGER.problemFinalizingPartitionExecution(e3, this.stepOrPartitionExecution.getStepExecutionId());
                }
            }
            this.jobContext.destroyArtifact(this.itemReader, this.itemWriter, this.itemProcessor, this.collector, this.checkpointAlgorithm);
            this.jobContext.destroyArtifact(this.allChunkRelatedListeners);
            try {
                this.tm.setTransactionTimeout(0);
                return;
            }
            catch (SystemException txSystemException) {
                BatchLogger.LOGGER.warn(this.toString(), txSystemException);
            }
            return;
        }
    }

    private void readProcessWriteItems() throws Exception {
        ProcessingInfo processingInfo = new ProcessingInfo();
        while (processingInfo.chunkState != ChunkState.JOB_STOPPED && (processingInfo.chunkState != ChunkState.DEPLETED || processingInfo.itemState == ItemState.TO_RETRY_READ || processingInfo.itemState == ItemState.TO_RETRY_PROCESS || processingInfo.itemState == ItemState.TO_RETRY_WRITE)) {
            try {
                switch (processingInfo.itemState) {
                    case TO_SKIP: {
                        processingInfo.itemState = ItemState.RUNNING;
                        break;
                    }
                    case TO_RETRY_READ: {
                        processingInfo.itemState = ItemState.RETRYING_READ;
                        break;
                    }
                    case TO_RETRY_PROCESS: {
                        processingInfo.itemState = ItemState.RETRYING_PROCESS;
                        break;
                    }
                    case TO_RETRY_WRITE: {
                        processingInfo.itemState = ItemState.RETRYING_WRITE;
                    }
                }
                if (processingInfo.chunkState == ChunkState.TO_START_NEW || processingInfo.chunkState == ChunkState.TO_RETRY || processingInfo.chunkState == ChunkState.RETRYING || processingInfo.chunkState == ChunkState.TO_END_RETRY) {
                    if (processingInfo.chunkState == ChunkState.TO_START_NEW || processingInfo.chunkState == ChunkState.TO_END_RETRY) {
                        processingInfo.reset();
                    }
                    if (this.tm.getStatus() != 0) {
                        if (this.tm.getStatus() == 1) {
                            this.tm.rollback();
                        }
                        if (this.checkpointAlgorithm != null) {
                            this.tm.setTransactionTimeout(this.checkpointAlgorithm.checkpointTimeout());
                            this.checkpointAlgorithm.beginCheckpoint();
                        }
                        this.tm.begin();
                    }
                    for (ChunkListener l : this.chunkListeners) {
                        l.beforeChunk();
                    }
                    this.beginCheckpoint(processingInfo);
                }
                if (processingInfo.itemState != ItemState.RETRYING_PROCESS && processingInfo.itemState != ItemState.RETRYING_WRITE) {
                    this.readItem(processingInfo);
                }
                if (this.itemRead != null && processingInfo.itemState != ItemState.RETRYING_WRITE) {
                    this.processItem(processingInfo);
                }
                if (processingInfo.toStopItem() || !this.isReadyToCheckpoint(processingInfo)) continue;
                this.doCheckpoint(processingInfo);
            }
            catch (Exception e) {
                for (ChunkListener l : this.chunkListeners) {
                    l.onError(e);
                }
                BatchLogger.LOGGER.log(Logger.Level.ERROR, processingInfo);
                throw e;
            }
        }
    }

    private void readItem(ProcessingInfo processingInfo) throws Exception {
        block17: {
            try {
                for (ItemReadListener l : this.itemReadListeners) {
                    l.beforeRead();
                }
                ++processingInfo.readPosition;
                this.itemRead = this.itemReader.readItem();
                if (this.itemRead != null) {
                    this.stepMetrics.increment(Metric.MetricType.READ_COUNT, 1L);
                    ++processingInfo.count;
                } else {
                    processingInfo.chunkState = ChunkState.DEPLETED;
                }
                for (ItemReadListener l : this.itemReadListeners) {
                    l.afterRead(this.itemRead);
                }
            }
            catch (Exception e) {
                for (ItemReadListener itemReadListener : this.itemReadListeners) {
                    itemReadListener.onReadError(e);
                }
                this.toSkipOrRetry(e, processingInfo);
                if (processingInfo.itemState == ItemState.TO_SKIP) {
                    for (SkipReadListener skipReadListener : this.skipReadListeners) {
                        skipReadListener.onSkipReadItem(e);
                    }
                    this.stepMetrics.increment(Metric.MetricType.READ_SKIP_COUNT, 1L);
                    ++this.skipCount;
                    this.itemRead = null;
                    processingInfo.checkpointPosition = processingInfo.readPosition;
                    this.stepOrPartitionExecution.setReaderCheckpointInfo(this.itemReader.checkpointInfo());
                    if (this.tm.getStatus() == 1 || this.tm.getStatus() == 4) {
                        this.tm.rollback();
                        if (processingInfo.chunkState == ChunkState.RUNNING) {
                            processingInfo.chunkState = ChunkState.TO_START_NEW;
                        }
                    }
                } else if (processingInfo.itemState == ItemState.TO_RETRY) {
                    for (RetryReadListener retryReadListener : this.retryReadListeners) {
                        retryReadListener.onRetryReadException(e);
                    }
                    ++this.retryCount;
                    if (this.needRollbackBeforeRetry(e)) {
                        this.rollbackCheckpoint(processingInfo, e);
                    } else {
                        processingInfo.itemState = ItemState.TO_RETRY_READ;
                    }
                    this.itemRead = null;
                } else {
                    throw e;
                }
                this.checkIfEndRetry(processingInfo);
                if (processingInfo.itemState != ItemState.RETRYING_READ) break block17;
                processingInfo.itemState = ItemState.RUNNING;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processItem(ProcessingInfo processingInfo) throws Exception {
        Object output;
        block18: {
            if (this.itemProcessor != null) {
                try {
                    for (ItemProcessListener l : this.itemProcessListeners) {
                        l.beforeProcess(this.itemRead);
                    }
                    output = this.itemProcessor.processItem(this.itemRead);
                    for (ItemProcessListener l : this.itemProcessListeners) {
                        l.afterProcess(this.itemRead, output);
                    }
                    if (output == null) {
                        this.stepMetrics.increment(Metric.MetricType.FILTER_COUNT, 1L);
                    }
                }
                catch (Exception e) {
                    for (ItemProcessListener itemProcessListener : this.itemProcessListeners) {
                        itemProcessListener.onProcessError(this.itemRead, e);
                    }
                    this.toSkipOrRetry(e, processingInfo);
                    if (processingInfo.itemState == ItemState.TO_SKIP) {
                        for (SkipProcessListener skipProcessListener : this.skipProcessListeners) {
                            skipProcessListener.onSkipProcessItem(this.itemRead, e);
                        }
                        this.stepMetrics.increment(Metric.MetricType.PROCESS_SKIP_COUNT, 1L);
                        ++this.skipCount;
                        output = null;
                        processingInfo.checkpointPosition = processingInfo.readPosition;
                        this.stepOrPartitionExecution.setReaderCheckpointInfo(this.itemReader.checkpointInfo());
                        if (this.tm.getStatus() != 1 && this.tm.getStatus() != 4) break block18;
                        this.tm.rollback();
                        if (processingInfo.chunkState == ChunkState.RUNNING) {
                            processingInfo.chunkState = ChunkState.TO_START_NEW;
                        }
                        break block18;
                    }
                    if (processingInfo.itemState != ItemState.TO_RETRY) {
                        throw e;
                    }
                    for (RetryProcessListener retryProcessListener : this.retryProcessListeners) {
                        retryProcessListener.onRetryProcessException(this.itemRead, e);
                    }
                    ++this.retryCount;
                    if (this.needRollbackBeforeRetry(e)) {
                        this.rollbackCheckpoint(processingInfo, e);
                    } else {
                        processingInfo.itemState = ItemState.TO_RETRY_PROCESS;
                    }
                    output = null;
                }
            } else {
                output = this.itemRead;
            }
        }
        if (output != null) {
            this.outputList.add(output);
        }
        if (processingInfo.itemState != ItemState.TO_RETRY_PROCESS) {
            this.itemRead = null;
        }
        this.checkIfEndRetry(processingInfo);
        if (processingInfo.itemState == ItemState.RETRYING_PROCESS) {
            processingInfo.itemState = ItemState.RUNNING;
        }
    }

    private void checkIfEndRetry(ProcessingInfo processingInfo) {
        if (processingInfo.chunkState == ChunkState.RETRYING && processingInfo.itemState != ItemState.TO_RETRY_READ && processingInfo.itemState != ItemState.TO_RETRY_PROCESS && processingInfo.itemState != ItemState.TO_RETRY_WRITE && processingInfo.readPosition == processingInfo.failurePoint) {
            processingInfo.chunkState = ChunkState.TO_END_RETRY;
        }
    }

    private void beginCheckpoint(final ProcessingInfo processingInfo) throws Exception {
        if (this.checkpointPolicy.equals("item") && this.timeLimit > 0) {
            Timer timer = new Timer("chunk-checkpoint-timer", true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    processingInfo.timerExpired = true;
                }
            }, this.timeLimit * 1000);
        }
        if (processingInfo.chunkState == ChunkState.TO_RETRY) {
            processingInfo.chunkState = ChunkState.RETRYING;
        } else if (processingInfo.chunkState != ChunkState.RETRYING) {
            processingInfo.chunkState = ChunkState.RUNNING;
        }
    }

    private boolean isReadyToCheckpoint(ProcessingInfo processingInfo) throws Exception {
        if (this.jobContext.getJobExecution().isStopRequested()) {
            processingInfo.chunkState = ChunkState.JOB_STOPPING;
            return true;
        }
        if (processingInfo.chunkState == ChunkState.TO_RETRY) {
            return false;
        }
        if (processingInfo.chunkState == ChunkState.DEPLETED || processingInfo.chunkState == ChunkState.RETRYING || processingInfo.chunkState == ChunkState.TO_END_RETRY) {
            return true;
        }
        if (this.checkpointPolicy.equals("item")) {
            if (processingInfo.count >= this.itemCount) {
                return true;
            }
            if (this.timeLimit > 0) {
                return processingInfo.timerExpired;
            }
            return false;
        }
        return this.checkpointAlgorithm.isReadyToCheckpoint();
    }

    private void doCheckpoint(ProcessingInfo processingInfo) throws Exception {
        boolean nothingToWrite = this.outputList.size() == 0 && processingInfo.chunkState == ChunkState.DEPLETED;
        Object backupReaderCheckpointInfo = ChunkState.TO_START_NEW;
        Object backupWriterCheckpointInfo = ChunkState.TO_START_NEW;
        try {
            if (!nothingToWrite) {
                for (ItemWriteListener itemWriteListener : this.itemWriteListeners) {
                    itemWriteListener.beforeWrite(this.outputList);
                }
                this.itemWriter.writeItems(this.outputList);
                this.stepMetrics.increment(Metric.MetricType.WRITE_COUNT, this.outputList.size());
                for (ItemWriteListener itemWriteListener : this.itemWriteListeners) {
                    itemWriteListener.afterWrite(this.outputList);
                }
            }
            for (ChunkListener chunkListener : this.chunkListeners) {
                chunkListener.afterChunk();
            }
            backupReaderCheckpointInfo = this.stepOrPartitionExecution.getReaderCheckpointInfo();
            backupWriterCheckpointInfo = this.stepOrPartitionExecution.getWriterCheckpointInfo();
            this.stepOrPartitionExecution.setReaderCheckpointInfo(this.itemReader.checkpointInfo());
            this.stepOrPartitionExecution.setWriterCheckpointInfo(this.itemWriter.checkpointInfo());
            int savedCount = ((StepContextImpl)this.batchContext).savePersistentData(false);
            if (savedCount == 0) {
                ((StepContextImpl)this.batchContext).savePersistentData(true);
                this.jobContext.getJobExecution().stop();
            }
            this.tm.commit();
            backupReaderCheckpointInfo = backupWriterCheckpointInfo = ChunkState.RUNNING;
            this.stepMetrics.increment(Metric.MetricType.COMMIT_COUNT, 1L);
            processingInfo.checkpointPosition = processingInfo.readPosition;
            this.outputList.clear();
            if (this.checkpointAlgorithm != null) {
                this.checkpointAlgorithm.endCheckpoint();
            }
            if (processingInfo.chunkState == ChunkState.JOB_STOPPING) {
                processingInfo.chunkState = ChunkState.JOB_STOPPED;
                ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPED);
            } else if (processingInfo.chunkState != ChunkState.DEPLETED && processingInfo.chunkState != ChunkState.RETRYING) {
                processingInfo.chunkState = ChunkState.TO_START_NEW;
            }
            if (this.collector != null && !nothingToWrite) {
                this.partitionWorker.reportData(this.collector.collectPartitionData(), this.stepOrPartitionExecution);
            }
        }
        catch (Exception e) {
            if (backupWriterCheckpointInfo != ChunkState.TO_START_NEW && backupWriterCheckpointInfo != ChunkState.RUNNING) {
                this.stepOrPartitionExecution.setReaderCheckpointInfo((Serializable)backupReaderCheckpointInfo);
                this.stepOrPartitionExecution.setWriterCheckpointInfo((Serializable)backupWriterCheckpointInfo);
            }
            for (ItemWriteListener itemWriteListener : this.itemWriteListeners) {
                itemWriteListener.onWriteError(this.outputList, e);
            }
            this.toSkipOrRetry(e, processingInfo);
            if (processingInfo.itemState == ItemState.TO_SKIP) {
                if (processingInfo.chunkState == ChunkState.JOB_STOPPING) {
                    processingInfo.chunkState = ChunkState.JOB_STOPPED;
                    ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPED);
                } else if (processingInfo.chunkState != ChunkState.JOB_STOPPED) {
                    for (SkipWriteListener skipWriteListener : this.skipWriteListeners) {
                        skipWriteListener.onSkipWriteItem(this.outputList, e);
                    }
                    this.stepMetrics.increment(Metric.MetricType.WRITE_SKIP_COUNT, 1L);
                    ++this.skipCount;
                    this.outputList.clear();
                    processingInfo.checkpointPosition = processingInfo.readPosition;
                    this.stepOrPartitionExecution.setReaderCheckpointInfo(this.itemReader.checkpointInfo());
                    this.stepOrPartitionExecution.setWriterCheckpointInfo(this.itemWriter.checkpointInfo());
                    if (this.tm.getStatus() == 0 || this.tm.getStatus() == 1 || this.tm.getStatus() == 4) {
                        this.tm.rollback();
                    }
                    if (processingInfo.chunkState == ChunkState.RUNNING) {
                        processingInfo.chunkState = ChunkState.TO_START_NEW;
                    }
                }
            }
            if (processingInfo.itemState == ItemState.TO_RETRY) {
                for (RetryWriteListener retryWriteListener : this.retryWriteListeners) {
                    retryWriteListener.onRetryWriteException(this.outputList, e);
                }
                ++this.retryCount;
                if (this.needRollbackBeforeRetry(e)) {
                    this.rollbackCheckpoint(processingInfo, e);
                } else {
                    processingInfo.itemState = ItemState.TO_RETRY_WRITE;
                }
            }
            throw e;
        }
        this.checkIfEndRetry(processingInfo);
        if (processingInfo.itemState == ItemState.RETRYING_WRITE) {
            processingInfo.itemState = ItemState.RUNNING;
        }
    }

    private void rollbackCheckpoint(ProcessingInfo processingInfo, Exception exception) throws Exception {
        this.outputList.clear();
        processingInfo.failurePoint = processingInfo.readPosition;
        for (ChunkListener l : this.chunkListeners) {
            l.onError(exception);
        }
        if (this.tm.getStatus() != 6) {
            this.tm.rollback();
        }
        this.stepMetrics.increment(Metric.MetricType.ROLLBACK_COUNT, 1L);
        try {
            this.closeItemWriter();
            this.closeItemReader();
        }
        catch (Exception e) {
            this.safeClose();
            throw e;
        }
        this.tm.begin();
        try {
            this.itemReaderClosed.set(false);
            this.itemReader.open(this.stepOrPartitionExecution.getReaderCheckpointInfo());
            processingInfo.readPosition = processingInfo.checkpointPosition;
            this.itemWriterClosed.set(false);
            this.itemWriter.open(this.stepOrPartitionExecution.getWriterCheckpointInfo());
            this.tm.commit();
        }
        catch (Exception e) {
            this.tm.rollback();
            this.safeClose();
            throw e;
        }
        processingInfo.chunkState = ChunkState.TO_RETRY;
        processingInfo.itemState = ItemState.RUNNING;
        if (this.collector != null) {
            this.partitionWorker.reportData(this.collector.collectPartitionData(), this.stepOrPartitionExecution);
        }
    }

    private boolean needSkip(Exception e) {
        return this.skippableExceptionClasses != null && (this.skipLimit >= 0 && this.skipCount < this.skipLimit || this.skipLimit < 0) && this.skippableExceptionClasses.matches(e.getClass());
    }

    private boolean needRetry(Exception e) {
        return this.retryableExceptionClasses != null && (this.retryLimit >= 0 && this.retryCount < this.retryLimit || this.retryLimit < 0) && this.retryableExceptionClasses.matches(e.getClass());
    }

    private void toSkipOrRetry(Exception e, ProcessingInfo processingInfo) {
        if (processingInfo.chunkState == ChunkState.RETRYING || processingInfo.chunkState == ChunkState.TO_END_RETRY || processingInfo.itemState == ItemState.RETRYING_READ || processingInfo.itemState == ItemState.RETRYING_PROCESS || processingInfo.itemState == ItemState.RETRYING_WRITE) {
            if (this.needSkip(e)) {
                processingInfo.itemState = ItemState.TO_SKIP;
                return;
            }
            if (this.needRetry(e)) {
                processingInfo.itemState = ItemState.TO_RETRY;
                return;
            }
        } else {
            if (this.needRetry(e)) {
                processingInfo.itemState = ItemState.TO_RETRY;
                return;
            }
            if (this.needSkip(e)) {
                processingInfo.itemState = ItemState.TO_SKIP;
                return;
            }
        }
    }

    private boolean needRollbackBeforeRetry(Exception e) {
        return this.noRollbackExceptionClasses == null || !this.noRollbackExceptionClasses.matches(e.getClass());
    }

    private void createChunkRelatedListeners() {
        Listeners listeners = ((StepContextImpl)this.batchContext).getStep().getListeners();
        if (listeners == null) {
            return;
        }
        for (RefArtifact l : listeners.getListeners()) {
            String ref = l.getRef();
            Object o = this.jobContext.createArtifact(ref, null, l.getProperties(), (StepContextImpl)this.batchContext);
            this.allChunkRelatedListeners.add(o);
            if (o instanceof ChunkListener) {
                this.chunkListeners.add((ChunkListener)o);
            }
            if (o instanceof ItemReadListener) {
                this.itemReadListeners.add((ItemReadListener)o);
            }
            if (o instanceof ItemWriteListener) {
                this.itemWriteListeners.add((ItemWriteListener)o);
            }
            if (o instanceof ItemProcessListener) {
                this.itemProcessListeners.add((ItemProcessListener)o);
            }
            if (o instanceof SkipReadListener) {
                this.skipReadListeners.add((SkipReadListener)o);
            }
            if (o instanceof SkipWriteListener) {
                this.skipWriteListeners.add((SkipWriteListener)o);
            }
            if (o instanceof SkipProcessListener) {
                this.skipProcessListeners.add((SkipProcessListener)o);
            }
            if (o instanceof RetryReadListener) {
                this.retryReadListeners.add((RetryReadListener)o);
            }
            if (o instanceof RetryWriteListener) {
                this.retryWriteListeners.add((RetryWriteListener)o);
            }
            if (!(o instanceof RetryProcessListener)) continue;
            this.retryProcessListeners.add((RetryProcessListener)o);
        }
    }

    private void safeClose() {
        try {
            if (this.itemWriter != null) {
                this.closeItemWriter();
            }
        }
        catch (Exception e) {
            BatchLogger.LOGGER.trace("Error closing ItemWriter.", e);
        }
        try {
            if (this.itemReader != null) {
                this.closeItemReader();
            }
        }
        catch (Exception e) {
            BatchLogger.LOGGER.trace("Error closing ItemReader.", e);
        }
    }

    private void closeItemReader() throws Exception {
        if (this.itemReaderClosed.compareAndSet(false, true)) {
            this.itemReader.close();
        }
    }

    private void closeItemWriter() throws Exception {
        if (this.itemWriterClosed.compareAndSet(false, true)) {
            this.itemWriter.close();
        }
    }

    private static final class ProcessingInfo {
        int count;
        boolean timerExpired;
        ItemState itemState = ItemState.RUNNING;
        ChunkState chunkState = ChunkState.TO_START_NEW;
        int checkpointPosition = -1;
        int readPosition = -1;
        Integer failurePoint;

        private ProcessingInfo() {
        }

        private void reset() {
            this.count = 0;
            this.timerExpired = false;
            this.itemState = ItemState.RUNNING;
            this.chunkState = ChunkState.RUNNING;
            this.failurePoint = null;
        }

        private boolean toStopItem() {
            return this.itemState == ItemState.TO_SKIP || this.itemState == ItemState.TO_RETRY || this.itemState == ItemState.TO_RETRY_READ || this.itemState == ItemState.TO_RETRY_PROCESS || this.itemState == ItemState.TO_RETRY_WRITE;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ProcessingInfo{");
            sb.append("count=").append(this.count);
            sb.append(", timerExpired=").append(this.timerExpired);
            sb.append(", itemState=").append((Object)this.itemState);
            sb.append(", chunkState=").append((Object)this.chunkState);
            sb.append(", checkpointPosition=").append(this.checkpointPosition);
            sb.append(", readPosition=").append(this.readPosition);
            sb.append(", failurePoint=").append(this.failurePoint);
            sb.append('}');
            return sb.toString();
        }
    }

    private static enum ChunkState {
        RUNNING,
        TO_RETRY,
        RETRYING,
        TO_END_RETRY,
        TO_START_NEW,
        DEPLETED,
        JOB_STOPPING,
        JOB_STOPPED;

    }

    private static enum ItemState {
        RUNNING,
        TO_SKIP,
        TO_RETRY,
        TO_RETRY_READ,
        RETRYING_READ,
        TO_RETRY_PROCESS,
        RETRYING_PROCESS,
        TO_RETRY_WRITE,
        RETRYING_WRITE;

    }
}

