/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import jakarta.batch.runtime.BatchStatus;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jberet._private.BatchLogger;
import org.jberet.job.model.Flow;
import org.jberet.job.model.JobElement;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.runtime.context.FlowContextImpl;
import org.jberet.runtime.runner.CompositeExecutionRunner;
import org.jberet.spi.JobTask;

public final class FlowExecutionRunner
extends CompositeExecutionRunner<FlowContextImpl>
implements JobTask {
    private final Flow flow;
    private final CountDownLatch latch;

    public FlowExecutionRunner(FlowContextImpl flowContext, CompositeExecutionRunner enclosingRunner, CountDownLatch latch) {
        super(flowContext, enclosingRunner);
        this.flow = flowContext.getFlow();
        this.latch = latch;
    }

    @Override
    protected List<? extends JobElement> getJobElements() {
        return this.flow.getJobElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ((FlowContextImpl)this.batchContext).setBatchStatus(BatchStatus.STARTED);
        this.jobContext.setBatchStatus(BatchStatus.STARTED);
        try {
            this.runFromHeadOrRestartPoint(null);
        }
        catch (Throwable e) {
            BatchLogger.LOGGER.failToRunJob(e, this.jobContext.getJobName(), this.flow.getId(), this.flow);
            ((FlowContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
            for (AbstractContext c : ((FlowContextImpl)this.batchContext).getOuterContexts()) {
                c.setBatchStatus(BatchStatus.FAILED);
            }
        }
        finally {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
        if (((FlowContextImpl)this.batchContext).getBatchStatus() == BatchStatus.STARTED) {
            ((FlowContextImpl)this.batchContext).setBatchStatus(BatchStatus.COMPLETED);
        }
        if (((FlowContextImpl)this.batchContext).getBatchStatus() == BatchStatus.COMPLETED) {
            String next = this.resolveTransitionElements(this.flow.getTransitionElements(), this.flow.getAttributeNext(), false);
            this.enclosingRunner.runJobElement(next, ((FlowContextImpl)this.batchContext).getFlowExecution().getLastStepExecution());
        }
    }
}

