/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import org.jboss.arquillian.impl.core.spi.EventContext;
import org.jboss.arquillian.impl.core.spi.context.ClassContext;
import org.jboss.arquillian.impl.core.spi.context.SuiteContext;
import org.jboss.arquillian.impl.core.spi.context.TestContext;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.jboss.arquillian.spi.event.suite.ClassEvent;
import org.jboss.arquillian.spi.event.suite.SuiteEvent;
import org.jboss.arquillian.spi.event.suite.TestEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContextHandler {
    @Inject
    private Instance<SuiteContext> suiteContextInstance;
    @Inject
    private Instance<ClassContext> classContextInstance;
    @Inject
    private Instance<TestContext> testContextInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSuiteContext(@Observes EventContext<SuiteEvent> context) {
        SuiteContext suiteContext = (SuiteContext)this.suiteContextInstance.get();
        try {
            suiteContext.activate();
            context.proceed();
        }
        finally {
            suiteContext.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createClassContext(@Observes EventContext<ClassEvent> context) {
        ClassContext classContext = (ClassContext)this.classContextInstance.get();
        try {
            classContext.activate(context.getEvent().getTestClass().getJavaClass());
            context.proceed();
        }
        finally {
            classContext.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestContext(@Observes EventContext<TestEvent> context) {
        TestContext testContext = (TestContext)this.testContextInstance.get();
        try {
            testContext.activate(context.getEvent().getTestInstance());
            context.proceed();
        }
        finally {
            testContext.deactivate();
        }
    }
}

