/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.container;

import org.jboss.arquillian.impl.client.container.event.ContainerMultiControlEvent;
import org.jboss.arquillian.impl.client.container.event.StartManagedContainers;
import org.jboss.arquillian.impl.client.container.event.StopManagedContainers;
import org.jboss.arquillian.impl.configuration.api.ArquillianDescriptor;
import org.jboss.arquillian.spi.core.Event;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.jboss.arquillian.spi.event.suite.BeforeClass;

public class ContainerRestarter {
    private int testClassesCount = 0;
    @Inject
    private Event<ContainerMultiControlEvent> controlEvent;
    @Inject
    private Instance<ArquillianDescriptor> configuration;

    public void restart(@Observes BeforeClass event) throws Exception {
        if (this.shouldRestart()) {
            this.controlEvent.fire((Object)new StopManagedContainers());
            this.controlEvent.fire((Object)new StartManagedContainers());
        }
    }

    private boolean shouldRestart() {
        ArquillianDescriptor descriptor = (ArquillianDescriptor)this.configuration.get();
        Integer maxTestClasses = descriptor.engine().getMaxTestClassesBeforeRestart();
        if (maxTestClasses == null) {
            return false;
        }
        if (maxTestClasses > -1 && maxTestClasses - 1 == this.testClassesCount) {
            this.testClassesCount = 0;
            return true;
        }
        ++this.testClassesCount;
        return false;
    }
}

