/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.container;

import java.util.Collection;
import org.jboss.arquillian.impl.client.container.event.DeployDeployment;
import org.jboss.arquillian.impl.core.spi.EventContext;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.client.container.DeploymentException;
import org.jboss.arquillian.spi.client.container.DeploymentExceptionTransformer;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentExceptionHandler {
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public void verifyExpectedExceptionDuringDeploy(@Observes EventContext<DeployDeployment> context) throws Exception {
        DeploymentDescription deployment = context.getEvent().getDeployment();
        boolean deploymentExceptionThrown = true;
        try {
            context.proceed();
            if (deployment.getExpectedException() != null) {
                deploymentExceptionThrown = false;
                throw new RuntimeException("Expected exception of type " + deployment.getExpectedException().getName() + " during deployment of " + deployment.getName() + ", but no exception was thrown.");
            }
        }
        catch (Exception e) {
            if (!deploymentExceptionThrown) {
                throw e;
            }
            if (deployment.getExpectedException() != null) {
                if (!this.containsType(this.transform(e), deployment.getExpectedException())) {
                    throw e;
                }
            }
            throw e;
        }
    }

    private boolean containsType(Throwable exception, Class<? extends Exception> expectedType) {
        if (exception == null) {
            return false;
        }
        if (expectedType.isAssignableFrom(exception.getClass())) {
            return true;
        }
        return this.containsType(exception.getCause(), expectedType);
    }

    private Throwable transform(Throwable exception) {
        Throwable toBeTransformed = exception;
        if (exception instanceof DeploymentException) {
            toBeTransformed = exception.getCause();
        }
        Collection transformers = ((ServiceLoader)this.serviceLoader.get()).all(DeploymentExceptionTransformer.class);
        for (DeploymentExceptionTransformer transformer : transformers) {
            Throwable transformed = transformer.transform(toBeTransformed);
            if (transformed == null) continue;
            return transformed;
        }
        return toBeTransformed;
    }
}

